package ru.yandex.avia.booking.partners.gateways.aeroflot.v3.requests;

import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

import ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model.DataLists;
import ru.yandex.avia.booking.partners.gateways.aeroflot.v3.model.Offer;
import ru.yandex.avia.booking.partners.gateways.model.booking.TravellerInfo;

@Value
@Builder
@AllArgsConstructor
public class OrderCreateRequestParams {
    // variant info
    private final String language;
    private final String countryOfSale;
    private final DataLists dataLists;
    private final Offer offer;
    // booking form data
    private final List<TravellerInfo> travellers;
    private final String contactEmail;
    private final Integer contactPhoneCountryCode;
    private final Long contactPhoneNumber;
    // payment data
    private final String tokenizedCard;
    private final String redirectUrl;
}
