package ru.yandex.avia.booking.partners.gateways.model.booking;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class BookingResponse {
    private BookingStatus status;
    private boolean canBeCancelled;
    private JsonNode providerData;
    private String pnr;
    private String providerRef;
    private List<BookingSegment> segments;
    private BookingPriceInfo priceInfo;
    // TODO move it somewhere to be near passengers
    private Map<String, List<String>> tickets;
    private CodeContext codeContext;
    private ZonedDateTime timeLimit;
    private byte[] documentData;
    private List<String> airlineRefs;
}
