package ru.yandex.avia.booking.partners.gateways.model.booking;

import java.time.LocalDate;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.avia.booking.enums.DocumentType;
import ru.yandex.avia.booking.enums.PassengerCategory;
import ru.yandex.avia.booking.enums.Sex;

@Data
@Builder(toBuilder = true)
@NoArgsConstructor // json support
@AllArgsConstructor
public class TravellerInfo {
    private String travellerInfoId;
    private PassengerCategory category;
    private String firstName;
    private String middleName;
    private String lastName;
    private String lastNameSuffix;
    private LocalDate dateOfBirth;
    private String nationalityCode;
    private Integer nationalityCodeGeoId;
    private String documentNumber;
    private LocalDate documentValidTill;
    private DocumentType documentType;
    private String loyaltyProgramCode;
    private String loyaltyProgramAccountNumber;
    private Sex sex;
}

