package ru.yandex.avia.booking.partners.gateways.model.search;

import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.javamoney.moneta.Money;

import ru.yandex.avia.booking.enums.PassengerCategory;

@Data
@Builder
@NoArgsConstructor // json conversion support
@AllArgsConstructor
public class CategoryPrice {
    private PassengerCategory passengerCategory;
    private int quantity;
    private Money total;
    private Money fare;
    private Money taxes;
    private List<FareInfo> fareInfo;

    public Money totalAmount() {
        return total.multiply(quantity);
    }
}
