package ru.yandex.avia.booking.partners.gateways.model.search;

import java.util.function.Predicate;

import com.google.common.collect.Streams;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.avia.booking.partners.gateways.model.search.filter.ChosenVariantFilter;
import ru.yandex.avia.booking.partners.gateways.model.search.filter.FlightFilter;
import ru.yandex.avia.booking.partners.gateways.model.search.filter.SegmentFilter;

public class ChosenVariantFilterPredicate implements Predicate<Variant> {

    private ChosenVariantFilter chosenVariantFilter;

    public ChosenVariantFilterPredicate(ChosenVariantFilter chosenVariantFilter) {
        this.chosenVariantFilter = chosenVariantFilter;
    }

    @Override
    public boolean test(Variant variant) {
        if (variant.getSegments().size() != chosenVariantFilter.getSegmentFilters().size()) {
            return false;
        }
        if (!variant.areAllSegmentsETicket()) {
            return false;
        }
        return Streams.zip(variant.getSegments().stream(), chosenVariantFilter.getSegmentFilters().stream(), Pair::of)
                .map(t -> ChosenVariantFilterPredicate.segmentValid(t.getLeft(), t.getRight()))
                .reduce((v1, v2) -> v1 && v2)
                .get();
    }

    private static boolean segmentValid(Segment segment, SegmentFilter segmentFilter) {
        if (segment.getFlights().size() != segmentFilter.getFlightFilters().size()) {
            return false;
        }
        return Streams.zip(segment.getFlights().stream(), segmentFilter.getFlightFilters().stream(), Pair::of)
                .map(t -> flightValid(t.getLeft(), t.getRight()))
                .reduce((v1, v2) -> v1 && v2)
                .get();
    }

    private static boolean flightValid(Flight flight, FlightFilter flightFilter) {
        return flight.getArrCode().equals(flightFilter.getArrCode())
                && flight.getDepCode().equals(flightFilter.getDepCode())
                && flight.getFlightNumber().equals(flightFilter.getFlightNumber())
                && flight.getMarketingAirlineCode().equals(flightFilter.getMarketingAcCode())
                && flight.getOperatingAirlineCode().equals(flightFilter.getOperatingAcCode());

    }
}
