package ru.yandex.avia.booking.partners.gateways.model.search;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class FareInfo {
    private String fareBasis;
    private String fareFamilyCode;
    private String flightId;

    @JsonIgnore
    // Removing the discount part
    public String getCanonicalFareBasis() {
        if (Strings.isNullOrEmpty(fareBasis)) {
            return fareBasis;
        }
        if (fareBasis.indexOf('/') > 0) {
            return fareBasis.substring(0, fareBasis.indexOf('/'));
        }
        return fareBasis;
    }
}
