package ru.yandex.avia.booking.partners.gateways.model.search;

import java.time.LocalDateTime;
import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.avia.booking.enums.ClassOfService;

@Data
@Builder
@NoArgsConstructor // json conversion support
@AllArgsConstructor
public class Flight {
    private String id;
    private String depCode;
    private String arrCode;
    private String marketingAirlineCode;
    private String operatingAirlineCode;
    private String flightNumber;
    private LocalDateTime departureDateTime;
    private LocalDateTime arrivalDateTime;
    private String bookingClassCode;
    private ClassOfService baseClass;
    private boolean eTicket;
    private List<FlightStop> flightStops;
    private Integer seatsLeft;
    private SeatsInfo aircraftSeats;

    public String getUniqueId() {
        return marketingAirlineCode + "/" + flightNumber + "/" + departureDateTime;
    }
}
