package ru.yandex.avia.booking.partners.gateways.model.search;

import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.avia.booking.partners.gateways.aeroflot.model.SearchData;
import ru.yandex.avia.booking.partners.gateways.model.booking.CodeContext;

@Data
@Builder(toBuilder = true)
@NoArgsConstructor // json conversion support
@AllArgsConstructor
public class Variant {
    private CodeContext codeContext;
    private String token;
    private List<Segment> segments;
    private PriceInfo priceInfo;
    private List<PriceInfo> allTariffs;
    private String countryOfSale;
    private String lang;
    private SearchData searchData;

    public boolean areAllSegmentsETicket() {
        return segments.stream().flatMap(s -> s.getFlights().stream()).allMatch(Flight::isETicket);
    }

    public boolean hasMultipleTariffs() {
        return allTariffs != null && !allTariffs.isEmpty();
    }
}
