package ru.yandex.avia.booking.partners.gateways.model.search.filter;

import java.time.LocalDate;
import java.util.List;

import com.google.common.collect.Lists;
import lombok.Data;

@Data
public class SegmentFilter {
    private List<FlightFilter> flightFilters = Lists.newArrayList();

    public String departureCode() {
        return flightFilters.get(0).getDepCode();
    }

    public String arrivalCode() {
        return flightFilters.get(flightFilters.size() - 1).getArrCode();
    }

    public LocalDate departureDate() {
        return flightFilters.get(0).getDepartureDateTime().toLocalDate();
    }
}
