package ru.yandex.avia.booking.promo;

import java.util.List;
import java.util.UUID;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AeroflotPlusPromoInfo {
    private boolean enabled;
    private List<PlusCode> plusCodes;
    // for internal usage
    private UUID emailTaskId;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class PlusCode {
        // for confirmed orders only
        private String code;
        private int points;
    }
}
