package ru.yandex.avia.booking.remote;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import lombok.Builder;
import lombok.Data;
import lombok.NonNull;
import lombok.experimental.Accessors;

@Data
@Builder(toBuilder = true)
@Accessors(chain = true)
public class RpcContext {
    // app context
    private UUID orderId;

    // internal settings
    private Map<String, String> extraHeaders;

    @NonNull
    public Map<String, String> getLoggingParams() {
        Map<String, String> params = new HashMap<>();
        if (orderId != null) {
            params.put("order_id", orderId.toString());
        }
        return params;
    }

    @NonNull
    public static RpcContext empty() {
        return builder().build();
    }
}
