package ru.yandex.avia.booking.remote;

import java.util.Map;
import java.util.UUID;

import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;

/**
 * This logger should be used in the following manner:
 * <pre>{@code
 *         try (RpcLogger rpcLogger = RpcLogger.newExchange(rpcContext)) {
 *             rpcLogger.log("request", request);
 *             String response = ...;
 *             rpcLogger.log("response", response);
 *             return ...;
 *         }}</pre>
 */
@Slf4j
public class RpcLogger implements AutoCloseable {
    private RpcLogger(@NonNull String exchangeId, @NonNull RpcContext context) {
        MDC.put("exchange_id", exchangeId);
        for (Map.Entry<String, String> logParam : context.getLoggingParams().entrySet()) {
            MDC.put(logParam.getKey(), logParam.getValue());
        }
    }

    @NonNull
    public static RpcLogger newExchange(@NonNull RpcContext context) {
        return new RpcLogger(UUID.randomUUID().toString(), context);
    }

    public void log(@NonNull String step, @NonNull String message) {
        try {
            MDC.put("exchange_step", step);
            log.info(message);
        } finally {
            MDC.remove("exchange_step");
        }
    }

    @Override
    public void close() {
        MDC.clear();
    }
}
