package ru.yandex.avia.booking.services.tdapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.avia.booking.partners.gateways.aeroflot.model.SearchData;

@Slf4j
public class AviaTicketDaemonUtils {
    public static SearchData.SearchParams parseSearchParamsSafe(@NonNull JsonNode tdData) {
        try {
            var builder = SearchData.SearchParams.builder();
            JsonNode params = tdData.get("additional_data");
            if (params != null) {
                builder.nationalVersion(params.get("national_version").textValue())
                        .lang(params.get("lang").textValue())
                        .klass(params.get("klass").textValue());
            }
            String qkey = tdData.at("/order_data/qkey").textValue();
            if (!Strings.isNullOrEmpty(qkey)) {
                String[] parts = qkey.split("_");
                if (parts.length >= 2) {
                    builder.pointFrom(parts[0])
                            .pointTo(parts[1]);
                }
            }
            return builder.build();
        } catch (Exception e) {
            log.warn("failed to parse td data", e);
            return null;
        }
    }
}
