# -*- coding: utf-8 -*-
import httplib
import socket
import urllib2

from django.conf import settings
from django.utils.http import urlencode
from lxml import etree
from ylog.utils import log_warning

from travel.avia.library.python.common.utils.http import urlopen

BASE_CURRENCY_CODE = 'RUR'


def fetch_rates(currencies_codes, geoid, base_currency_code=None):
    """Получает на входе КОДЫ валют, а не модели"""

    if not base_currency_code:
        base_currency_code = BASE_CURRENCY_CODE

    try:
        src, rates = _fetch_rates(currencies_codes, geoid, base_currency_code)
    except (urllib2.HTTPError, urllib2.URLError, IOError, socket.error,
            TypeError, ValueError, httplib.BadStatusLine):
        log_warning()

        src, rates = None, {}

    rates[base_currency_code] = 1

    return src, rates


def _fetch_rates(currencies_codes, geoid, base_currency_code):
    """ https://wiki.yandex-team.ru/VladimirSavenkov/ConvRasp/ """
    if not settings.CURRENCY_RATES_URL:
        return None, {}

    if not (set(currencies_codes) - set([base_currency_code])):
        return base_currency_code, {}

    params = {
        'from': base_currency_code,
        'to': [code for code in currencies_codes if code != base_currency_code],
        'geoid': geoid,
        'srv': 'avia',
    }

    url = settings.CURRENCY_RATES_URL + '?' + urlencode(params, doseq=True)

    xml = urlopen(url, timeout=settings.CURRENCY_RATES_TIMEOUT)
    tree = etree.parse(xml)

    status = tree.xpath('/response/status')[0].text

    if status != 'ok':
        return None, {}

    src = tree.xpath('/response/data/src')[0].text

    rates = dict(
        (to.attrib['id'], float(to.attrib['value']))
        for to in tree.xpath('/response/data/rates/to')
    )

    return src, rates
