# -*- coding: utf-8 -*-
import requests


def fetch_rates(currencies_codes, base_currency):
    """Получает на входе КОДЫ валют, а не модели"""

    src, rates = _fetch_rates(currencies_codes, base_currency)

    if rates.get(base_currency) != 1.0:
        return None, {}

    return src, rates


DOHOP_CURRENCY_RATES_URL = (
    'https://yandexapi.dohop.com/api/v1/locale/en?pretty=yes'
)


def _fetch_rates(currencies_codes, base_currency):
    """ https://st.yandex-team.ru/RASPTICKETS-5444 """
    result = requests.get(DOHOP_CURRENCY_RATES_URL, timeout=1).json()
    available_currencies = set(currencies_codes)
    available_currencies.add(base_currency)

    rates = {}

    for currency in result['currencies']:
        code, rate, name = currency

        if code == 'RUB':
            code = 'RUR'

        if code not in available_currencies:
            continue

        if rate:
            rates[code] = 1.0/rate

    return 'dohop', rates
