# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
from travel.avia.library.python.avia_data import storage
from travel.avia.library.python.avia_data.models import amadeus_merchant
from travel.avia.library.python.common.models.partner import PartnerLogoFileSystemStorage
import django.db.models.deletion
from django.conf import settings
from travel.avia.library.python.common.utils.fields import TrimmedCharField
import django.core.validators


class Migration(migrations.Migration):

    dependencies = [
        ('order', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('www', '0001_initial'),
        ('currency', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='SettlementBigImage',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('gradient_css', models.TextField(default=b'', editable=False, blank=True)),
                ('url', models.CharField(max_length=250, verbose_name='\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435')),
                ('big_url',
                 models.CharField(
                     max_length=250,
                     verbose_name='\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0431\u043e\u043b\u044c\u0448\u043e\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435')),
                ('small_url',
                 models.CharField(max_length=250,
                                  verbose_name='\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u043c\u0430\u043b\u0435'
                                  '\u043d\u044c\u043a\u043e\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435')),
                ('large_url',
                 models.CharField(
                     max_length=250,
                     verbose_name='\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u043e\u0433\u0440\u043e'
                                  '\u043c\u043d\u043e\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435'
                 )),
                ('header_url',
                 models.CharField(
                     max_length=250,
                     verbose_name='\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0432 \u0448\u0430\u043f\u043a\u0435')),
            ],
            options={
                'managed': False,
                'ordering': ['settlement'],
                'abstract': False,
                'verbose_name_plural': '\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0433\u043e\u0440\u043e\u0434\u043e\u0432',
                'db_table': 'avia_settlementbigimage',
                'verbose_name': '\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0433\u043e\u0440\u043e\u0434\u0430',
            },
        ),
        migrations.CreateModel(
            name='AdminSettlementBigImage',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('gradient_css', models.TextField(default=b'', editable=False, blank=True)),
                ('url',
                 models.ImageField(storage=storage.YFStorage(album=b'454155', token=b'2e01a50b7a254420b0f2ebc76f5761bb', user=b'yndx-service-avia'),
                                   upload_to=b'default',
                                   max_length=250,
                                   verbose_name='\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435')),
                ('big_url',
                 models.ImageField(
                     default=b'',
                     storage=storage.YFStorage(album=b'456056', token=b'2e01a50b7a254420b0f2ebc76f5761bb', user=b'yndx-service-avia'),
                     upload_to=b'default',
                     max_length=250,
                     blank=True,
                     verbose_name='\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0431\u043e\u043b\u044c\u0448\u043e\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435',
                 )),
                ('small_url',
                 models.ImageField(
                     default=b'',
                     storage=storage.YFStorage(album=b'456057', token=b'2e01a50b7a254420b0f2ebc76f5761bb', user=b'yndx-service-avia'),
                     upload_to=b'default',
                     max_length=250,
                     blank=True,
                     verbose_name='\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u043c\u0430\u043b'
                     '\u0435\u043d\u044c\u043a\u043e\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435',
                 )),
                ('large_url',
                 models.ImageField(
                     default=b'',
                     storage=storage.YFStorage(album=b'456057', token=b'2e01a50b7a254420b0f2ebc76f5761bb', user=b'yndx-service-avia'),
                     upload_to=b'default',
                     max_length=250,
                     blank=True,
                     verbose_name='\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u043e\u0433\u0440\u043e'
                     '\u043c\u043d\u043e\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435',
                 )),
                ('header_url',
                 models.ImageField(
                     default=b'',
                     storage=storage.YFStorage(album=b'456057', token=b'2e01a50b7a254420b0f2ebc76f5761bb', user=b'yndx-service-avia'),
                     upload_to=b'default',
                     max_length=250,
                     blank=True,
                     verbose_name='\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0432 \u0448\u0430\u043f\u043a\u0435',
                 )),
                ('settlement', models.OneToOneField(related_name='+', null=True, verbose_name='\u0413\u043e\u0440\u043e\u0434', to='www.Settlement')),
            ],
            options={
                'ordering': ['settlement'],
                'abstract': False,
                'db_table': 'avia_settlementbigimage',
                'verbose_name': '\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0433\u043e\u0440\u043e\u0434\u0430',
                'verbose_name_plural': '\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0433\u043e\u0440\u043e\u0434\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='AmadeusMerchant',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('description_ru_ru',
                 models.TextField(null=True,
                                  verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u0440'
                                  '\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438',
                                  blank=True)),
                ('description_ua_uk',
                 models.TextField(null=True,
                                  verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u0443'
                                  '\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (uk)',
                                  blank=True)),
                ('description_ua_ru',
                 models.TextField(null=True,
                                  verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u0443'
                                  '\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (ru)',
                                  blank=True)),
                ('description_tr_tr',
                 models.TextField(null=True,
                                  verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u0442'
                                  '\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (tr)',
                                  blank=True)),
                ('description_tr_en',
                 models.TextField(null=True,
                                  verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u0442'
                                  '\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (en)',
                                  blank=True)),
                ('merchant_id', TrimmedCharField(unique=True, max_length=2, verbose_name='ID \u043c\u0435\u0440\u0447\u0430\u043d\u0442\u0430')),
                ('code', TrimmedCharField(db_index=True, max_length=10, verbose_name='\u041a\u043e\u0434 \u043f\u0430\u0440\u0442\u043d\u0451\u0440\u0430', blank=True)),
                ('review_percent', models.IntegerField(default=0, verbose_name='\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u043f\u0440\u043e\u0432\u0435\u0440\u043e\u043a', blank=True)),
                ('logo_svg_ru',
                 amadeus_merchant.SvgImageField(
                     default=None,
                     storage=PartnerLogoFileSystemStorage(),
                     upload_to=amadeus_merchant.UploadToGetter(b'partners/svg', b'amadeus', b'ru', b'svg'),
                     blank=True,
                     null=True,
                     verbose_name='\u0426\u0432\u0435\u0442\u043d\u043e\u0439 \u043b\u043e\u0433\u043e\u0442'
                     '\u0438\u043f \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440'
                     '\u0441\u0438\u0438 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 svg',
                 )),
                ('logo_svg_ua',
                 amadeus_merchant.SvgImageField(
                     default=None,
                     storage=PartnerLogoFileSystemStorage(),
                     upload_to=amadeus_merchant.UploadToGetter(b'partners/svg', b'amadeus', b'ua', b'svg'),
                     blank=True,
                     null=True,
                     verbose_name='\u0426\u0432\u0435\u0442\u043d\u043e\u0439 \u043b\u043e\u0433\u043e\u0442'
                     '\u0438\u043f \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 '
                     '\u0432\u0435\u0440\u0441\u0438\u0438 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 svg',
                 )),
                ('logo_svg_tr',
                 amadeus_merchant.SvgImageField(
                     default=None,
                     storage=PartnerLogoFileSystemStorage(),
                     upload_to=amadeus_merchant.UploadToGetter(b'partners/svg', b'amadeus', b'tr', b'svg'),
                     blank=True,
                     null=True,
                     verbose_name='\u0426\u0432\u0435\u0442\u043d\u043e\u0439 \u043b\u043e\u0433\u043e\u0442'
                     '\u0438\u043f \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435'
                     '\u0440\u0441\u0438\u0438 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 svg',
                 )),
                ('logo_svg_com',
                 amadeus_merchant.SvgImageField(
                     default=None,
                     storage=PartnerLogoFileSystemStorage(),
                     upload_to=amadeus_merchant.UploadToGetter(b'partners/svg', b'amadeus', b'com', b'svg'),
                     blank=True,
                     null=True,
                     verbose_name='\u0426\u0432\u0435\u0442\u043d\u043e\u0439 \u043b\u043e\u0433\u043e\u0442'
                     '\u0438\u043f com \u0432\u0435\u0440\u0441\u0438\u0438 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 svg',
                 )),
                ('logo_svg2png_ru',
                 amadeus_merchant.CustomImageField(
                     default=None,
                     storage=PartnerLogoFileSystemStorage(),
                     upload_to=amadeus_merchant.UploadToGetter(b'partners/svg2png', b'amadeus', b'ru', b'png'),
                     blank=True,
                     null=True,
                     verbose_name='\u0420\u0435\u043d\u0434\u0435\u0440\u0435\u043d\u043d\u044b\u0439 svg2png '
                     '\u043b\u043e\u0433\u043e\u0442\u0438\u043f \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438',
                 )),
                ('logo_svg2png_ua',
                 amadeus_merchant.CustomImageField(
                     default=None,
                     storage=PartnerLogoFileSystemStorage(),
                     upload_to=amadeus_merchant.UploadToGetter(b'partners/svg2png', b'amadeus', b'ua', b'png'),
                     blank=True,
                     null=True,
                     verbose_name='\u0420\u0435\u043d\u0434\u0435\u0440\u0435\u043d\u043d\u044b\u0439 svg2png '
                     '\u043b\u043e\u0433\u043e\u0442\u0438\u043f \u0443\u043a\u0440\u0430\u0438\u043d'
                     '\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438',
                 )),
                ('logo_svg2png_tr',
                 amadeus_merchant.CustomImageField(
                     default=None,
                     storage=PartnerLogoFileSystemStorage(),
                     upload_to=amadeus_merchant.UploadToGetter(b'partners/svg2png', b'amadeus', b'tr', b'png'),
                     blank=True,
                     null=True,
                     verbose_name='\u0420\u0435\u043d\u0434\u0435\u0440\u0435\u043d\u043d\u044b\u0439 svg2png '
                     '\u043b\u043e\u0433\u043e\u0442\u0438\u043f \u0442\u0443\u0440\u0435\u0446'
                     '\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438',
                 )),
                ('logo_svg2png_com',
                 amadeus_merchant.CustomImageField(
                     default=None,
                     storage=PartnerLogoFileSystemStorage(),
                     upload_to=amadeus_merchant.UploadToGetter(b'partners/svg2png', b'amadeus', b'com', b'png'),
                     blank=True,
                     null=True,
                     verbose_name='\u0420\u0435\u043d\u0434\u0435\u0440\u0435\u043d\u043d\u044b\u0439 svg2png '
                     '\u043b\u043e\u0433\u043e\u0442\u0438\u043f com \u0432\u0435\u0440\u0441\u0438\u0438',
                 )),
                ('enabled_in_ticket_ru', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041a\u0411 (ru)')),
                ('enabled_in_ticket_ua', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041a\u0411 (ua)')),
                ('enabled_in_ticket_tr', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041a\u0411 (tr)')),
                ('enabled_in_ticket_com', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041a\u0411 (com)')),
                ('enabled_in_rasp_ru', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041f\u041c (ru)')),
                ('enabled_in_rasp_ua', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041f\u041c (ua)')),
                ('enabled_in_rasp_tr', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041f\u041c (tr)')),
                ('enabled_in_mobile_ticket_ru',
                 models.BooleanField(
                     default=False,
                     verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d'
                                  '\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041a\u0411 (ru)'
                 )),
                ('enabled_in_mobile_ticket_ua',
                 models.BooleanField(
                     default=False,
                     verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 '
                                  '\u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041a\u0411 (ua)'
                 )),
                ('enabled_in_mobile_ticket_tr',
                 models.BooleanField(
                     default=False,
                     verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d'
                                  '\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041a\u0411 (tr)'
                 )),
                ('enabled_in_mobile_ticket_com',
                 models.BooleanField(
                     default=False,
                     verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d'
                                  '\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041a\u0411 (com)')),
                ('enabled_in_mobile_rasp_ru',
                 models.BooleanField(
                     default=False,
                     verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d'
                                  '\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041f\u041c (ru)'
                 )),
                ('enabled_in_mobile_rasp_ua',
                 models.BooleanField(
                     default=False,
                     verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d'
                                  '\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041f\u041c (ua)'
                 )),
                ('enabled_in_mobile_rasp_tr',
                 models.BooleanField(
                     default=False,
                     verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d'
                                  '\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041f\u041c (tr)'
                 )),
                ('enabled',
                 models.BooleanField(
                     default=False,
                     verbose_name='\u041c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430'
                                  '\u043f\u0440\u043e\u0448\u0435\u043d \u0447\u0435\u0440\u0435\u0437 \u0434\u0435\u043c\u043e\u043d\u0430')),
                ('foreign_currency',
                 models.BooleanField(
                     default=False,
                     help_text='\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442'
                               '\u044c \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f '
                               '\u0432 \u0432\u0430\u043b\u044e\u0442\u0430\u0445 \u043e\u0442\u043b\u0438'
                               '\u0447\u043d\u044b\u0445 \u043e\u0442 \u0432\u0430\u043b\u044e\u0442\u044b '
                               '\u043d\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0439 '
                               '\u0432\u0435\u0440\u0441\u0438\u0438',
                     verbose_name='\u0418\u043d\u043e\u0441\u0442\u0440\u0430\u043d\u043d\u044b\u0435 \u0432\u0430\u043b\u044e\u0442\u044b')),
                ('is_aviacompany', models.BooleanField(default=False, verbose_name='\u0410\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f')),
                ('national_ua_title_ru',
                 TrimmedCharField(
                     default='',
                     max_length=100,
                     null=True,
                     verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (ru)',
                     blank=True)),
                ('national_ua_title_en',
                 TrimmedCharField(
                     default='',
                     max_length=100,
                     null=True,
                     verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (en)',
                     blank=True)),
                ('national_ua_title_tr',
                 TrimmedCharField(
                     default='',
                     max_length=100,
                     null=True,
                     verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (tr)',
                     blank=True)),
                ('national_ua_title_uk',
                 TrimmedCharField(
                     default='',
                     max_length=100,
                     null=True,
                     verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (uk)',
                     blank=True)),
                ('title',
                 TrimmedCharField(default='', max_length=100, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430')),
                ('title_ru',
                 TrimmedCharField(default='',
                                                      max_length=100,
                                                      null=True,
                                                      verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 (ru)',
                                                      blank=True)),
                ('title_en',
                 TrimmedCharField(default='',
                                                      max_length=100,
                                                      null=True,
                                                      verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 (en)',
                                                      blank=True)),
                ('title_tr',
                 TrimmedCharField(default='',
                                                      max_length=100,
                                                      null=True,
                                                      verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 (tr)',
                                                      blank=True)),
                ('title_uk',
                 TrimmedCharField(default='',
                                                      max_length=100,
                                                      null=True,
                                                      verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 (uk)',
                                                      blank=True)),
                ('national_ru_title_ru',
                 TrimmedCharField(
                     default='',
                     max_length=100,
                     null=True,
                     verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (ru)',
                     blank=True)),
                ('national_ru_title_en',
                 TrimmedCharField(
                     default='',
                     max_length=100,
                     null=True,
                     verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (en)',
                     blank=True)),
                ('national_ru_title_tr',
                 TrimmedCharField(
                     default='',
                     max_length=100,
                     null=True,
                     verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (tr)',
                     blank=True)),
                ('national_ru_title_uk',
                 TrimmedCharField(
                     default='',
                     max_length=100,
                     null=True,
                     verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (uk)',
                     blank=True)),
                ('national_tr_title_ru',
                 TrimmedCharField(
                     default='',
                     max_length=100,
                     null=True,
                     verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (ru)',
                     blank=True)),
                ('national_tr_title_en',
                 TrimmedCharField(
                     default='',
                     max_length=100,
                     null=True,
                     verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (en)',
                     blank=True)),
                ('national_tr_title_tr',
                 TrimmedCharField(
                     default='',
                     max_length=100,
                     null=True,
                     verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (tr)',
                     blank=True)),
                ('national_tr_title_uk',
                 TrimmedCharField(
                     default='',
                     max_length=100,
                     null=True,
                     verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (uk)',
                     blank=True)),
                ('national_com_ru',
                 TrimmedCharField(default='',
                                                      max_length=100,
                                                      null=True,
                                                      verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 com \u0432\u0435\u0440\u0441\u0438\u0438 (ru)',
                                                      blank=True)),
                ('national_com_en',
                 TrimmedCharField(default='',
                                                      max_length=100,
                                                      null=True,
                                                      verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 com \u0432\u0435\u0440\u0441\u0438\u0438 (en)',
                                                      blank=True)),
                ('national_com_tr',
                 TrimmedCharField(default='',
                                                      max_length=100,
                                                      null=True,
                                                      verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 com \u0432\u0435\u0440\u0441\u0438\u0438 (tr)',
                                                      blank=True)),
                ('national_com_uk',
                 TrimmedCharField(default='',
                                                      max_length=100,
                                                      null=True,
                                                      verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 com \u0432\u0435\u0440\u0441\u0438\u0438 (uk)',
                                                      blank=True)),
                ('t_type', models.ForeignKey(related_name='+', default=2, verbose_name='\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType')),
            ],
            options={
                'ordering': ('code', ),
                'db_table': 'avia_amadeusmerchant',
                'verbose_name': '\u041c\u0435\u0440\u0447\u0430\u043d\u0442 Amadeus',
                'verbose_name_plural': '\u041c\u0435\u0440\u0447\u0430\u043d\u0442\u044b Amadeus',
            },
        ),
        migrations.CreateModel(
            name='AvgPrice',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('price', models.IntegerField(null=True, verbose_name='\u0421\u0440\u0435\u0434\u043d\u044f\u044f \u0446\u0435\u043d\u0430', blank=True)),
                ('month_forward', models.PositiveSmallIntegerField(verbose_name='\u041c\u0435\u0441\u044f\u0446 \u0432\u044b\u043b\u0435\u0442\u0430')),
                ('year_forward', models.PositiveSmallIntegerField(verbose_name='\u0413\u043e\u0434 \u0432\u044b\u043b\u0435\u0442\u0430')),
                ('month_backward', models.PositiveSmallIntegerField(null=True, verbose_name='\u041c\u0435\u0441\u044f\u0446 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d\u0438\u044f')),
                ('year_backward', models.PositiveSmallIntegerField(null=True, verbose_name='\u0413\u043e\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d\u0438\u044f')),
                ('passengers', models.CharField(max_length=5, verbose_name='\u041f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u044b')),
                ('national_version',
                 models.CharField(max_length=5, verbose_name='\u041d\u0430\u0446. \u0432\u0435\u0440\u0441\u0438\u044f', choices=[(b'ru', b'ru'), (b'ua', b'ua'), (b'tr', b'tr'), (b'com', b'com')])),
                ('direct_flight', models.BooleanField(default=None)),
                ('arrival_settlement',
                 models.ForeignKey(related_name='avg_price_arrival_settlement',
                                   verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f',
                                   to='www.Settlement',
                                   db_index=False)),
            ],
            options={
                'db_table': 'avia_avgprice',
                'verbose_name': '\u0421\u0440\u0435\u0434\u043d\u044f\u044f \u0446\u0435\u043d\u0430',
                'verbose_name_plural': '\u0421\u0440\u0435\u0434\u043d\u0438\u0435 \u0446\u0435\u043d\u044b \u0432 \u0433\u0438\u0431\u043a\u043e\u043c \u043f\u043e\u0438\u0441\u043a\u0435',
            },
        ),
        migrations.CreateModel(
            name='AviaCompany',
            fields=[
                ('rasp_company', models.OneToOneField(primary_key=True, serialize=False, to='www.Company')),
                ('cost_type',
                 TrimmedCharField(default=b'normal',
                                                      max_length=7,
                                                      verbose_name='\u0411\u044e\u0434\u0436\u0435\u0442',
                                                      choices=[(b'normal', b'Normal'), (b'lowcost', b'Lowcost'), (b'hybrid', b'Hybrid')])),
                ('baggage_rules',
                 models.TextField(default=b'', verbose_name='\u041f\u0440\u0430\u0432\u0438\u043b\u0430 \u043f\u0440\u043e\u0432\u043e\u0437\u0430 \u0431\u0430\u0433\u0430\u0436\u0430', blank=True)),
                ('baggage_rules_url',
                 TrimmedCharField(
                     default=b'',
                     max_length=255,
                     verbose_name='\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u043f\u0440\u0430\u0432'
                                  '\u0438\u043b\u0430 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438 '
                                  '\u0431\u0430\u0433\u0430\u0436\u0430 \u043d\u0430 \u0441\u0430\u0439\u0442\u0435 \u0410\u041a',
                     blank=True)),
                ('baggage_length', models.IntegerField(null=True, verbose_name='\u0411\u0430\u0433\u0430\u0436, \u0434\u043b\u0438\u043d\u0430, \u0441\u043c', blank=True)),
                ('baggage_width', models.IntegerField(null=True, verbose_name='\u0411\u0430\u0433\u0430\u0436, \u0448\u0438\u0440\u0438\u043d\u0430, \u0441\u043c', blank=True)),
                ('baggage_height', models.IntegerField(null=True, verbose_name='\u0411\u0430\u0433\u0430\u0436, \u0432\u044b\u0441\u043e\u0442\u0430, \u0441\u043c', blank=True)),
                ('baggage_dimensions_sum',
                 models.IntegerField(null=True,
                                     verbose_name='\u0411\u0430\u0433\u0430\u0436, \u0441\u0443\u043c\u043c\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u0439, \u0441\u043c',
                                     blank=True)),
                ('carryon_length',
                 models.IntegerField(null=True, verbose_name='\u0420\u0443\u0447\u043d\u0430\u044f \u043a\u043b\u0430\u0434\u044c, \u0434\u043b\u0438\u043d\u0430, \u0441\u043c', blank=True)),
                ('carryon_width',
                 models.IntegerField(null=True, verbose_name='\u0420\u0443\u0447\u043d\u0430\u044f \u043a\u043b\u0430\u0434\u044c, \u0448\u0438\u0440\u0438\u043d\u0430, \u0441\u043c', blank=True)),
                ('carryon_height',
                 models.IntegerField(null=True, verbose_name='\u0420\u0443\u0447\u043d\u0430\u044f \u043a\u043b\u0430\u0434\u044c, \u0432\u044b\u0441\u043e\u0442\u0430, \u0441\u043c', blank=True)),
                ('carryon_dimensions_sum',
                 models.IntegerField(
                     null=True,
                     verbose_name='\u0420\u0443\u0447\u043d\u0430\u044f \u043a\u043b\u0430\u0434\u044c, \u0441'
                                  '\u0443\u043c\u043c\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u0439, \u0441\u043c',
                     blank=True)),
            ],
            options={
                'db_table': 'avia_aviacompany',
                'verbose_name': '\u0410\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438',
                'verbose_name_plural': '\u0410\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438',
            },
        ),
        migrations.CreateModel(
            name='AviaDirection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('direct_flights', models.IntegerField(default=0, verbose_name='\u041a\u043e\u043b-\u0432\u043e \u043f\u0440\u044f\u043c\u044b\u0445 \u0440\u0435\u0439\u0441\u043e\u0432')),
                ('connecting_flights',
                 models.IntegerField(default=0,
                                     verbose_name='\u041a\u043e\u043b-\u0432\u043e \u0440\u0435\u0439\u0441\u043e\u0432 c \u043f\u0435\u0440\u0435\u0441\u0430\u0434\u043a\u0430\u043c\u0438')),
                ('popularity', models.IntegerField(default=0, verbose_name='\u041f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u043e\u0441\u0442\u044c')),
                ('arrival_settlement',
                 models.ForeignKey(related_name='air_traffic_arrival_settlement', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', to='www.Settlement')),
                ('departure_settlement',
                 models.ForeignKey(related_name='air_traffic_departure_settlement',
                                   verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                                   to='www.Settlement')),
            ],
            options={
                'ordering': ['departure_settlement', '-popularity'],
                'db_table': 'avia_aviadirection',
            },
        ),
        migrations.CreateModel(
            name='AviaDirectionNational',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('direct_flights', models.IntegerField(default=0, verbose_name='\u041a\u043e\u043b-\u0432\u043e \u043f\u0440\u044f\u043c\u044b\u0445 \u0440\u0435\u0439\u0441\u043e\u0432')),
                ('connecting_flights',
                 models.IntegerField(default=0,
                                     verbose_name='\u041a\u043e\u043b-\u0432\u043e \u0440\u0435\u0439\u0441\u043e\u0432 c \u043f\u0435\u0440\u0435\u0441\u0430\u0434\u043a\u0430\u043c\u0438')),
                ('popularity', models.IntegerField(default=0, verbose_name='\u041f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u043e\u0441\u0442\u044c')),
                ('national_version', models.CharField(default=b'ru', max_length=5, verbose_name='\u0422\u0438\u043f', choices=[(b'ru', b'ru'), (b'ua', b'ua'), (b'tr', b'tr'), (b'com', b'com')])),
                ('arrival_settlement',
                 models.ForeignKey(related_name='air_traffic_arrival_settlement_national',
                                   verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f',
                                   to='www.Settlement')),
                ('departure_settlement',
                 models.ForeignKey(related_name='air_traffic_departure_settlement_national',
                                   verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                                   to='www.Settlement')),
            ],
            options={
                'ordering': ['national_version', 'departure_settlement', '-popularity'],
                'db_table': 'avia_aviadirectionnational',
            },
        ),
        migrations.CreateModel(
            name='AviaRecipe',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('slug',
                 models.SlugField(
                     help_text='\u041b\u0430\u0442\u0438\u043d\u0441\u043a\u0438\u0435 \u0431\u0443\u043a'
                               '\u0432\u044b \u0438 \u0446\u0438\u0444\u0440\u044b, \u043d\u0435 \u0431'
                               '\u043e\u043b\u0435\u0435 32, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 happy-new-year-2016',
                     max_length=32,
                     verbose_name='\u0410\u0434\u0440\u0435\u0441',
                     blank=True)),
                ('enabled_ru', models.BooleanField(default=False, verbose_name='\u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c (ru)')),
                ('enabled_ua', models.BooleanField(default=False, verbose_name='\u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c (ua)')),
                ('enabled_tr', models.BooleanField(default=False, verbose_name='\u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c (tr)')),
                ('enabled_com', models.BooleanField(default=False, verbose_name='\u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c (com)')),
                ('recipe_type',
                 models.CharField(
                     help_text='\n            <strong>\u041f\u043e\u043f\u0443\u043b\u044f\u0440\u043d'
                               '\u044b\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438'
                               '\u044f</strong> \u2013 \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0437'
                               '\u0432\u0435\u0441\u0442\u043d\u044b\u0435 \u043d\u0430\u043c \u043f\u043e'
                               '\u043f. \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f '
                               '\u0438\u0437 \u0433\u043e\u0440\u043e\u0434\u0430 \u043f\u043e\u043b\u044c'
                               '\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f<br>\n            <strong>'
                               '\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0435 \u0446'
                               '\u0435\u043d\u044b</strong> \u2013 \u043f\u043e \u0432\u0441\u0435\u043c '
                               '\u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u043c \u0446'
                               '\u0435\u043d\u0430\u043c \u0438\u0437 \u0433\u043e\u0440\u043e\u0434\u0430 '
                               '\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f\n        ',
                     max_length=150,
                     verbose_name='\u0422\u0438\u043f',
                     choices=[(b'popular', '\u041f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u044b\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f'),
                              (b'prices', '\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0435 \u0446\u0435\u043d\u044b')])),
                ('week_days',
                 models.CharField(
                     help_text='\u0441\u043f\u0438\u0441\u043e\u043a \u0447\u0435\u0440\u0435\u0437 \u0437'
                               '\u0430\u043f\u044f\u0442\u0443\u044e (1 - \u043f\u043d, 2 - \u0432\u0442, ..., 7 - \u0432\u0441)',
                     max_length=50,
                     verbose_name='\u0414\u043d\u0438 \u043d\u0435\u0434\u0435\u043b\u0438',
                     blank=True)),
                ('date_start', models.DateField(null=True, verbose_name='\u0412\u0430\u0440\u0438\u0430\u043d\u0442\u044b \u0441', blank=True)),
                ('date_end', models.DateField(null=True, verbose_name='\u0412\u0430\u0440\u0438\u0430\u043d\u0442\u044b \u043f\u043e', blank=True)),
                ('show_start', models.DateField(null=True, verbose_name='\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0441', blank=True)),
                ('show_end', models.DateField(null=True, verbose_name='\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043f\u043e', blank=True)),
                ('show_year', models.BooleanField(default=True, verbose_name='\u0423\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c \u0433\u043e\u0434')),
                ('order', models.IntegerField(default=0, verbose_name='\u041f\u043e\u0440\u044f\u0434\u043e\u043a')),
                ('title_ru', TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('title_en', TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('title_tr', TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('title_uk', TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
                ('h1_ru', TrimmedCharField(default=None, max_length=250, null=True, verbose_name='H1 (ru)', blank=True)),
                ('h1_en', TrimmedCharField(default=None, max_length=250, null=True, verbose_name='H1 (en)', blank=True)),
                ('h1_tr', TrimmedCharField(default=None, max_length=250, null=True, verbose_name='H1 (tr)', blank=True)),
                ('h1_uk', TrimmedCharField(default=None, max_length=250, null=True, verbose_name='H1 (uk)', blank=True)),
                ('meta_description_ru', models.TextField(verbose_name='Meta description (ru)', blank=True)),
                ('meta_description_en', models.TextField(verbose_name='Meta description (en)', blank=True)),
                ('meta_description_tr', models.TextField(verbose_name='Meta description (tr)', blank=True)),
                ('meta_description_uk', models.TextField(verbose_name='Meta description (uk)', blank=True)),
                ('meta_title_ru', TrimmedCharField(default=None, max_length=250, null=True, verbose_name='Meta title (ru)', blank=True)),
                ('meta_title_en', TrimmedCharField(default=None, max_length=250, null=True, verbose_name='Meta title (en)', blank=True)),
                ('meta_title_tr', TrimmedCharField(default=None, max_length=250, null=True, verbose_name='Meta title (tr)', blank=True)),
                ('meta_title_uk', TrimmedCharField(default=None, max_length=250, null=True, verbose_name='Meta title (uk)', blank=True)),
                ('countries', models.ManyToManyField(to='www.Country', verbose_name='\u0421\u0442\u0440\u0430\u043d\u044b', blank=True)),
                ('from_regions',
                 models.ManyToManyField(
                     default=None,
                     related_name='avia_recipe_from_regions',
                     verbose_name='\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c \u0442'
                                  '\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0440\u0435\u0433\u0438\u043e\u043d\u043e\u0432',
                     to='www.Region',
                     blank=True)),
                ('from_settlements',
                 models.ManyToManyField(
                     default=None,
                     related_name='avia_recipe_from_settlements',
                     verbose_name='\u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0433\u043e\u0440\u043e\u0434\u043e\u0432',
                     to='www.Settlement',
                     blank=True)),
                ('regions', models.ManyToManyField(to='www.Region', verbose_name='\u0420\u0435\u0433\u0438\u043e\u043d\u044b', blank=True)),
                ('settlements', models.ManyToManyField(to='www.Settlement', verbose_name='\u0413\u043e\u0440\u043e\u0434\u0430', blank=True)),
            ],
            options={
                'ordering': ['order'],
                'db_table': 'avia_aviarecipe',
                'verbose_name': '\u0430\u0432\u0438\u0430 \u0440\u0435\u0446\u0435\u043f\u0442',
                'verbose_name_plural': '\u0430\u0432\u0438\u0430 \u0440\u0435\u0446\u0435\u043f\u0442\u044b',
            },
        ),
        migrations.CreateModel(
            name='AviaSettlement',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('arrival', models.BooleanField(default=False, verbose_name='\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u0435')),
                ('popularity', models.IntegerField(default=0, verbose_name='\u041f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u043e\u0441\u0442\u044c')),
                ('settlement', models.ForeignKey(related_name='avia_settlement', verbose_name='\u0413\u043e\u0440\u043e\u0434', to='www.Settlement')),
            ],
            options={
                'ordering': ['settlement', '-popularity'],
                'db_table': 'avia_aviasettlement',
            },
        ),
        migrations.CreateModel(
            name='AviaSettlementNational',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('arrival', models.BooleanField(default=False, verbose_name='\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u0435')),
                ('popularity', models.IntegerField(default=0, verbose_name='\u041f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u043e\u0441\u0442\u044c')),
                ('national_version', models.CharField(default=b'ru', max_length=5, verbose_name='\u0422\u0438\u043f', choices=[(b'ru', b'ru'), (b'ua', b'ua'), (b'tr', b'tr'), (b'com', b'com')])),
                ('settlement', models.ForeignKey(related_name='avia_settlement_national', verbose_name='\u0413\u043e\u0440\u043e\u0434', to='www.Settlement')),
            ],
            options={
                'ordering': ['national_version', 'settlement', '-popularity'],
                'db_table': 'avia_aviasettlementnational',
            },
        ),
        migrations.CreateModel(
            name='AviaWizardDirection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('settlement_1',
                 models.ForeignKey(
                     related_name='+',
                     verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432'
                                  '\u043b\u0435\u043d\u0438\u044f \u0438\u043b\u0438 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f',
                     to='www.Settlement')),
                ('settlement_2',
                 models.ForeignKey(
                     related_name='+',
                     verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442'
                                  '\u0438\u044f \u0438\u043b\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                     to='www.Settlement')),
            ],
            options={
                'ordering': ['settlement_1__title_ru', 'settlement_1__title', 'settlement_2__title_ru', 'settlement_2__title'],
                'db_table': 'avia_aviawizarddirection',
                'verbose_name': '\u0430\u0432\u0438\u0430\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043a\u043e\u043b\u0434\u0443\u043d\u0449\u0438\u043a\u0430',
                'verbose_name_plural': '\u0430\u0432\u0438\u0430\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043a\u043e\u043b\u0434\u0443\u043d\u0449\u0438\u043a\u0430',
            },
        ),
        migrations.CreateModel(
            name='BestOffers',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('direction', models.CharField(max_length=15, verbose_name='\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435', db_index=True)),
                ('forward_date', models.DateField(verbose_name='\u0414\u0430\u0442\u0430 \u0432\u044b\u043b\u0435\u0442\u0430')),
                ('backward_date', models.DateField(null=True, verbose_name='\u0414\u0430\u0442\u0430 \u043f\u0440\u0438\u043b\u0435\u0442\u0430')),
                ('forward_route', models.CharField(max_length=128, verbose_name='\u0420\u0435\u0441\u044b \u0442\u0443\u0434\u0430', db_index=True)),
                ('backward_route', models.CharField(max_length=128, null=True, verbose_name='\u0420\u0435\u0441\u044b \u0442\u0443\u0434\u0430', db_index=True)),
                ('price', models.IntegerField(null=True, verbose_name='\u0426\u0435\u043d\u0430', blank=True)),
                ('national_version',
                 models.CharField(default=b'ru',
                                  max_length=5,
                                  verbose_name='\u041d\u0430\u0446. \u0432\u0435\u0440\u0441\u0438\u044f',
                                  choices=[(b'ru', b'ru'), (b'ua', b'ua'), (b'tr', b'tr'), (b'com', b'com')])),
            ],
            options={
                'db_table': 'avia_bestoffers',
                'verbose_name': '\u0438\u043d\u0442\u0435\u0440\u0435\u0441\u043d\u044b\u0435 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f',
                'verbose_name_plural': '\u0438\u043d\u0442\u0440\u0435\u0441\u043d\u044b\u0435 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f',
            },
        ),
        migrations.CreateModel(
            name='CompanyTariff',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('description',
                 TrimmedCharField(default=b'',
                                                      max_length=255,
                                                      verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043a\u043e\u0434\u0430 \u0442\u0430\u0440\u0438\u0444\u0430',
                                                      blank=True)),
                ('mask',
                 TrimmedCharField(default=b'',
                                                      max_length=100,
                                                      verbose_name='\u041c\u0430\u0441\u043a\u0430 \u043a\u043e\u0434\u0430 \u0442\u0430\u0440\u0438\u0444\u0430',
                                                      blank=True)),
                ('baggage_allowed', models.BooleanField(default=True, verbose_name='\u041d\u0430\u043b\u0438\u0447\u0438\u0435 \u0431\u0430\u0433\u0430\u0436\u0430')),
                ('baggage_norm', models.FloatField(null=True, verbose_name='\u041d\u043e\u0440\u043c\u0430 \u0431\u0430\u0433\u0430\u0436\u0430, \u043a\u0433', blank=True)),
                ('carryon', models.BooleanField(default=True, verbose_name='\u0420\u0443\u0447\u043d\u0430\u044f \u043a\u043b\u0430\u0434\u044c')),
                ('carryon_norm',
                 models.FloatField(null=True, verbose_name='\u041d\u043e\u0440\u043c\u0430 \u0440\u0443\u0447\u043d\u043e\u0439 \u043a\u043b\u0430\u0434\u0438, \u043a\u0433', blank=True)),
                ('published', models.BooleanField(default=False, verbose_name='\u041e\u043f\u0443\u0431\u043b\u0438\u043a\u043e\u0432\u0430\u043d')),
                ('avia_company', models.ForeignKey(related_name='tariffs', verbose_name='\u0410\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f', to='avia_data.AviaCompany')),
            ],
            options={
                'ordering': ('avia_company', ),
                'db_table': 'avia_companytariff',
                'verbose_name': '\u0422\u0430\u0440\u0438\u0444 \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438',
                'verbose_name_plural': '\u0422\u0430\u0440\u0438\u0444\u044b \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438',
            },
        ),
        migrations.CreateModel(
            name='Currency',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432\u0430\u043b\u044e\u0442\u044b')),
                ('code', models.CharField(max_length=3, verbose_name='\u041a\u043e\u0434', db_index=True)),
                ('iso_code', models.CharField(max_length=3, verbose_name='\u041a\u043e\u0434 ISO 4217', db_index=True)),
                ('priority',
                 models.PositiveSmallIntegerField(default=0, verbose_name='\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442 \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438')),
                ('enable', models.BooleanField(default=False, verbose_name='\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c')),
            ],
            options={
                'ordering': ('title', ),
                'db_table': 'avia_currency',
                'verbose_name': '\u0412\u0430\u043b\u044e\u0442\u0430',
                'verbose_name_plural': '\u0412\u0430\u043b\u044e\u0442\u044b',
            },
        ),
        migrations.CreateModel(
            name='CurrencyLang',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u044f\u0437\u044b\u043a\u0430')),
                ('code', models.CharField(max_length=2, verbose_name='\u041a\u043e\u0434', db_index=True)),
                ('enable', models.BooleanField(default=False, verbose_name='\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c')),
            ],
            options={
                'ordering': ('code', ),
                'db_table': 'avia_currencylang',
                'verbose_name': '\u042f\u0437\u044b\u043a \u0432\u0430\u043b\u044e\u0442',
                'verbose_name_plural': '\u042f\u0437\u044b\u043a\u0438 \u0432\u0430\u043b\u044e\u0442',
            },
        ),
        migrations.CreateModel(
            name='CurrencyTranslation',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title',
                 models.CharField(help_text='\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440: \u0420\u0443\u0431\u043b\u0438',
                                  max_length=100,
                                  verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432\u0430\u043b\u044e\u0442\u044b')),
                ('title_in',
                 models.CharField(help_text='\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440: \u0432&nbsp;\u0440\u0443\u0431\u043b\u044f\u0445',
                                  max_length=100,
                                  verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 "\u0432"',
                                  blank=True)),
                ('template',
                 models.CharField(help_text='\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440: %d&nbsp;\u0440. %d&nbsp;\u043a.',
                                  max_length=100,
                                  null=True,
                                  verbose_name='\u0428\u0430\u0431\u043b\u043e\u043d',
                                  blank=True)),
                ('template_whole',
                 models.CharField(help_text='\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440: %d&nbsp;\u0440. %d&nbsp;\u043a.',
                                  max_length=100,
                                  null=True,
                                  verbose_name='\u0428\u0430\u0431\u043b\u043e\u043d \u0431\u0435\u0437 \u0446\u0435\u043d\u0442\u043e\u0432',
                                  blank=True)),
                ('template_cents',
                 models.CharField(help_text='\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440: %d&nbsp;\u0440. %d&nbsp;\u043a.',
                                  max_length=100,
                                  null=True,
                                  verbose_name='\u0428\u0430\u0431\u043b\u043e\u043d \u0446\u0435\u043d\u0442\u043e\u0432',
                                  blank=True)),
                ('currency', models.ForeignKey(verbose_name='\u0412\u0430\u043b\u044e\u0442\u0430', to='avia_data.Currency')),
                ('lang', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, verbose_name='\u042f\u0437\u044b\u043a \u0432\u0430\u043b\u044e\u0442\u044b', to='avia_data.CurrencyLang')),
            ],
            options={
                'ordering': ('currency', ),
                'db_table': 'avia_currencytranslation',
                'verbose_name': '\u041f\u0435\u0440\u0435\u0432\u043e\u0434 \u0434\u043b\u044f \u0432\u0430\u043b\u044e\u0442\u044b',
                'verbose_name_plural': '\u041f\u0435\u0440\u0435\u0432\u043e\u0434\u044b \u0434\u043b\u044f \u0432\u0430\u043b\u044e\u0442',
            },
        ),
        migrations.CreateModel(
            name='CustomCacheTimeDirection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('roundtrip', models.BooleanField(default=True, verbose_name='\u0418 \u043e\u0431\u0440\u0430\u0442\u043d\u043e')),
                ('time',
                 models.IntegerField(default=30,
                                     verbose_name='\u0412\u0440\u0435\u043c\u044f \u043a\u0435\u0448\u0430 \u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445',
                                     validators=[django.core.validators.MaxValueValidator(30), django.core.validators.MinValueValidator(3)])),
                ('enabled', models.BooleanField(default=False, verbose_name='\u0412\u043a\u043b\u044e\u0447\u0435\u043d')),
                ('point_from', models.ForeignKey(related_name='+', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043e\u0442\u043a\u0443\u0434\u0430', blank=True, to='www.Settlement', null=True)),
                ('point_to', models.ForeignKey(related_name='+', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043a\u0443\u0434\u0430', blank=True, to='www.Settlement', null=True)),
            ],
            options={
                'db_table':
                'avia_customcachetimedirection',
                'verbose_name': '\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 '
                                '\u0441 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u043c \u0432'
                                '\u0440\u0435\u043c\u0435\u043d\u0435\u043c \u0436\u0438\u0437\u043d\u0438',
                'verbose_name_plural': '\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f '
                                       '\u0441 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u043c \u0432'
                                       '\u0440\u0435\u043c\u0435\u043d\u0435\u043c \u0436\u0438\u0437\u043d\u0438',
            },
        ),
        migrations.CreateModel(
            name='FlightNumber',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('flight_number', models.CharField(default=b'', max_length=10, verbose_name='\u041d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430', db_index=True)),
            ],
            options={
                'db_table': 'avia_flightnumber',
                'verbose_name': '\u041d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430',
                'verbose_name_plural': '\u041d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430',
            },
        ),
        migrations.CreateModel(
            name='FlightRating',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', models.CharField(max_length=10, verbose_name='\u0420\u0435\u0439\u0441')),
                ('scores', models.IntegerField(verbose_name='\u0411\u0430\u043b\u043b\u044b')),
                ('good_count', models.IntegerField(verbose_name='\u041a\u043e\u043b-\u0432\u043e \u0445\u043e\u0440\u043e\u0448\u0438\u0445')),
                ('bad_count', models.IntegerField(verbose_name='\u041a\u043e\u043b-\u0432\u043e \u043f\u043b\u043e\u0445\u0438\u0445')),
                ('bad_percent', models.IntegerField(verbose_name='\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u043f\u043b\u043e\u0445\u0438\u0445', db_index=True)),
                ('avg_scores', models.FloatField(verbose_name='\u0421\u0440\u0435\u0434\u043d\u0438\u0439 \u0431\u0430\u043b\u043b', db_index=True)),
                ('scores_description', models.TextField(null=True, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
                ('outrunning', models.IntegerField(default=0, verbose_name='\u041e\u043f\u0435\u0440\u0435\u0436\u0435\u043d\u0438\u0435')),
                ('delayed_less_30', models.IntegerField(default=0, verbose_name='\u041e\u043f\u043e\u0437\u0434\u0430\u043d\u0438\u0435 < 30')),
                ('delayed_30_60', models.IntegerField(default=0, verbose_name='\u041e\u043f\u043e\u0437\u0434\u0430\u043d\u0438\u0435 30-60')),
                ('delayed_60_90', models.IntegerField(default=0, verbose_name='\u041e\u043f\u043e\u0437\u0434\u0430\u043d\u0438\u0435 60-90')),
                ('delayed_more_90', models.IntegerField(default=0, verbose_name='\u041e\u043f\u043e\u0437\u0434\u0430\u043d\u0438\u0435 > 90')),
                ('canceled', models.IntegerField(default=0, verbose_name='\u041e\u0442\u043c\u0435\u043d\u0435\u043d')),
            ],
            options={
                'ordering': ['avg_scores', 'number'],
                'db_table': 'avia_flightrating',
                'verbose_name': '\u0440\u0435\u0439\u0442\u0438\u043d\u0433 \u0440\u0435\u0439\u0441\u0430',
                'verbose_name_plural': '\u0440\u0435\u0439\u0442\u0438\u043d\u0433\u0438 \u0440\u0435\u0439\u0441\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='FlightReview',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('review_id', models.CharField(max_length=64, verbose_name='review_ID', db_index=True)),
                ('review_content', models.TextField(verbose_name='\u0422\u0435\u043a\u0441\u0442 \u043e\u0442\u0437\u044b\u0432\u0430')),
                ('review_datetime', models.DateTimeField(verbose_name='\u0414\u0430\u0442\u0430 \u043e\u0442\u0437\u044b\u0432\u0430', db_index=True)),
                ('review_url', models.CharField(max_length=255, verbose_name='URL')),
                ('rating', models.PositiveIntegerField(blank=True, null=True, verbose_name='\u0420\u0435\u0439\u0442\u0438\u043d\u0433', validators=[django.core.validators.MaxValueValidator(5)])),
                ('author_name', models.CharField(max_length=255, null=True, verbose_name='\u0418\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044f', blank=True)),
                ('author_email', models.EmailField(max_length=254, null=True, verbose_name='Email \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f', blank=True)),
                ('flight_date', models.DateField(null=True, verbose_name='\u0414\u0430\u0442\u0430 \u0440\u0435\u0439\u0441\u0430', blank=True)),
                ('enable_show', models.NullBooleanField(db_index=True, verbose_name='\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u043f\u043e\u043a\u0430\u0437')),
                ('moderated_lmt', models.DateTimeField(null=True, verbose_name='\u0414\u0430\u0442\u0430 \u043c\u043e\u0434\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f', blank=True)),
                ('airline', models.ForeignKey(related_name='avia_data_flightreview_airline', verbose_name='\u041f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a', to='www.Company')),
                ('flight_numbers', models.ManyToManyField(to='avia_data.FlightNumber', verbose_name='\u041d\u043e\u043c\u0435\u0440\u0430 \u0440\u0435\u0439\u0441\u043e\u0432', blank=True)),
                ('moderator',
                 models.ForeignKey(related_name='avia_data_flightreview_moderator',
                                   verbose_name='\u041c\u043e\u0434\u0435\u0440\u0430\u0442\u043e\u0440',
                                   blank=True,
                                   to=settings.AUTH_USER_MODEL,
                                   null=True)),
                ('settlement_from',
                 models.ForeignKey(related_name='avia_data_flightreview_settlement_from',
                                   verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                                   blank=True,
                                   to='www.Settlement',
                                   null=True)),
                ('settlement_to',
                 models.ForeignKey(related_name='avia_data_flightreview_settlement_to',
                                   verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f',
                                   blank=True,
                                   to='www.Settlement',
                                   null=True)),
            ],
            options={
                'db_table': 'avia_flightreview',
                'verbose_name': '\u043e\u0442\u0437\u044b\u0432',
                'verbose_name_plural': '\u043e\u0442\u0437\u044b\u0432\u044b',
            },
        ),
        migrations.CreateModel(
            name='FlightReviewSource',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(max_length=32)),
                ('enabled', models.BooleanField(default=False, db_index=True, verbose_name='\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d')),
                ('title',
                 TrimmedCharField(default='',
                                                      max_length=100,
                                                      verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430')),
                ('title_ru',
                 TrimmedCharField(default='',
                                                      max_length=100,
                                                      null=True,
                                                      verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 (ru)',
                                                      blank=True)),
                ('title_en',
                 TrimmedCharField(default='',
                                                      max_length=100,
                                                      null=True,
                                                      verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 (en)',
                                                      blank=True)),
                ('title_tr',
                 TrimmedCharField(default='',
                                                      max_length=100,
                                                      null=True,
                                                      verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 (tr)',
                                                      blank=True)),
                ('title_uk',
                 TrimmedCharField(default='',
                                                      max_length=100,
                                                      null=True,
                                                      verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 (uk)',
                                                      blank=True)),
            ],
            options={
                'db_table': 'avia_flightreviewsource',
                'verbose_name': '\u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a',
                'verbose_name_plural': '\u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0438',
            },
        ),
        migrations.CreateModel(
            name='MinCountryPrice',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('price', models.IntegerField(null=True, verbose_name='\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0446\u0435\u043d\u0430', blank=True)),
                ('eventtime', models.DateTimeField(null=True, verbose_name='\u0412\u0440\u0435\u043c\u044f \u0441\u043e\u0431\u044b\u0442\u0438\u044f')),
                ('date_forward', models.DateField(null=True, verbose_name='\u0414\u0430\u0442\u0430 \u0432\u044b\u043b\u0435\u0442\u0430')),
                ('date_backward', models.DateField(null=True, verbose_name='\u0414\u0430\u0442\u0430 \u043f\u0440\u0438\u043b\u0435\u0442\u0430')),
                ('passengers', models.CharField(max_length=5, null=True, verbose_name='\u041f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u044b')),
                ('routes', models.CharField(max_length=128, null=True, verbose_name='\u041d\u043e\u043c\u0435\u0440\u0430 \u0440\u0435\u0439\u0441\u043e\u0432')),
                ('national_version',
                 models.CharField(default=b'ru',
                                  max_length=5,
                                  verbose_name='\u041d\u0430\u0446. \u0432\u0435\u0440\u0441\u0438\u044f',
                                  choices=[(b'ru', b'ru'), (b'ua', b'ua'), (b'tr', b'tr'), (b'com', b'com')])),
                ('direct_flight', models.NullBooleanField(default=None)),
                ('day_of_week', models.PositiveSmallIntegerField(default=None, null=True, choices=[(0, 0), (1, 1), (2, 2), (3, 3), (4, 4), (5, 5), (6, 6)])),
                ('arrival_country', models.ForeignKey(related_name='+', verbose_name='\u0421\u0442\u0440\u0430\u043d\u0430 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', to='www.Country')),
                ('currency', models.ForeignKey(related_name='+', verbose_name='\u0412\u0430\u043b\u044e\u0442\u0430', to='currency.Currency', null=True)),
                ('departure_country',
                 models.ForeignKey(related_name='+', verbose_name='\u0421\u0442\u0440\u0430\u043d\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', to='www.Country')),
            ],
            options={
                'db_table':
                'www_mincountryprice',
                'verbose_name': '\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0446'
                                '\u0435\u043d\u0430 \u0434\u043b\u044f \u0441\u0442\u0440\u0430\u043d\u044b',
                'verbose_name_plural': '\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0435 '
                                       '\u0446\u0435\u043d\u044b \u0434\u043b\u044f \u0441\u0442\u0440\u0430'
                                       '\u043d\u044b \u043d\u0430 \u043c\u043e\u0440\u0434\u0435 \u0433\u043e\u0440\u043e\u0434\u0430',
            },
        ),
        migrations.CreateModel(
            name='MinPrice',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('price', models.IntegerField(null=True, verbose_name='\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0446\u0435\u043d\u0430', blank=True)),
                ('eventtime', models.DateTimeField(null=True, verbose_name='\u0412\u0440\u0435\u043c\u044f \u0441\u043e\u0431\u044b\u0442\u0438\u044f')),
                ('date_forward', models.DateField(null=True, verbose_name='\u0414\u0430\u0442\u0430 \u0432\u044b\u043b\u0435\u0442\u0430')),
                ('date_backward', models.DateField(null=True, verbose_name='\u0414\u0430\u0442\u0430 \u043f\u0440\u0438\u043b\u0435\u0442\u0430')),
                ('passengers', models.CharField(max_length=5, null=True, verbose_name='\u041f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u044b')),
                ('routes', models.TextField(null=True, verbose_name='\u041d\u043e\u043c\u0435\u0440\u0430 \u0440\u0435\u0439\u0441\u043e\u0432')),
                ('national_version',
                 models.CharField(default=b'ru',
                                  max_length=5,
                                  verbose_name='\u041d\u0430\u0446. \u0432\u0435\u0440\u0441\u0438\u044f',
                                  choices=[(b'ru', b'ru'), (b'ua', b'ua'), (b'tr', b'tr'), (b'com', b'com')])),
                ('direct_flight', models.NullBooleanField(default=None)),
                ('day_of_week', models.PositiveSmallIntegerField(default=None, null=True, choices=[(0, 0), (1, 1), (2, 2), (3, 3), (4, 4), (5, 5), (6, 6)])),
                ('arrival_settlement',
                 models.ForeignKey(related_name='min_price_arrival_settlement', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', to='www.Settlement')),
                ('currency', models.ForeignKey(related_name='min_price_currency', verbose_name='\u0412\u0430\u043b\u044e\u0442\u0430', to='currency.Currency', null=True)),
                ('departure_settlement',
                 models.ForeignKey(related_name='min_price_departure_settlement',
                                   verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                                   to='www.Settlement')),
            ],
            options={
                'db_table': 'www_minprice',
                'verbose_name': '\u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0446\u0435\u043d\u0430',
                'verbose_name_plural': '\u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0435 \u0446\u0435\u043d\u044b',
            },
        ),
        migrations.CreateModel(
            name='NearAirports',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('min_distance', models.IntegerField(null=True, verbose_name='\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f', blank=True)),
                ('default_distance',
                 models.IntegerField(
                     help_text='\u0427\u0442\u043e\u0431\u044b \u043f\u0440\u0438\u043d\u0443\u0434\u0438'
                               '\u0442\u0435\u043b\u044c\u043d\u043e \u0441\u043a\u0440\u044b\u0442\u044c '
                               '\u0431\u043b\u043e\u043a \u0430\u044d\u0440\u043e\u043f\u043e\u0440\u0442'
                               '\u043e\u0432 - \u043d\u0443\u0436\u043d\u043e \u0443\u0431\u0440\u0430\u0442'
                               '\u044c \u044d\u0442\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435',
                     null=True,
                     verbose_name='\u041f\u043e-\u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e',
                     blank=True)),
                ('max_distance', models.IntegerField(null=True, verbose_name='\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f', blank=True)),
                ('settlement', models.OneToOneField(related_name='near_options', verbose_name='\u0413\u043e\u0440\u043e\u0434', to='www.Settlement')),
            ],
            options={
                'db_table': 'avia_nearairports',
                'verbose_name': '\u0431\u043b\u0438\u0436\u0430\u0439\u0448\u0438\u0439 \u0430\u044d\u0440\u043e\u043f\u043e\u0440\u0442',
                'verbose_name_plural': '\u0431\u043b\u0438\u0436\u0430\u0439\u0448\u0438\u0435 \u0430\u044d\u0440\u043e\u043f\u043e\u0440\u0442\u044b',
            },
        ),
        migrations.CreateModel(
            name='NearCountries',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('country', models.ForeignKey(related_name='near_countries', verbose_name='\u0421\u0442\u0440\u0430\u043d\u0430', to='www.Country')),
                ('neighbours', models.ManyToManyField(related_name='_nearcountries_neighbours_+', verbose_name='\u0421\u043e\u0441\u0435\u0434\u0438', to='www.Country')),
            ],
            options={
                'ordering': ('country__title', ),
                'db_table': 'avia_nearcountries',
                'verbose_name': '\u0441\u043e\u0441\u0435\u0434\u0438 \u0441\u0442\u0440\u0430\u043d\u044b',
                'verbose_name_plural': '\u0441\u043e\u0441\u0435\u0434\u0438 \u0441\u0442\u0440\u0430\u043d',
            },
        ),
        migrations.CreateModel(
            name='NearDirection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('min_distance', models.IntegerField(null=True, verbose_name='\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f', blank=True)),
                ('default_distance',
                 models.IntegerField(
                     help_text='\u0427\u0442\u043e\u0431\u044b \u043f\u0440\u0438\u043d\u0443\u0434'
                               '\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0441\u043a\u0440\u044b'
                               '\u0442\u044c \u0431\u043b\u043e\u043a \u0430\u044d\u0440\u043e\u043f'
                               '\u043e\u0440\u0442\u043e\u0432 - \u043d\u0443\u0436\u043d\u043e \u0443'
                               '\u0431\u0440\u0430\u0442\u044c \u044d\u0442\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435',
                     null=True,
                     verbose_name='\u041f\u043e-\u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e',
                     blank=True)),
                ('max_distance', models.IntegerField(null=True, verbose_name='\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f', blank=True)),
                ('arrival_settlement',
                 models.ForeignKey(related_name='near_arrival', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', to='www.Settlement')),
                ('departure_settlement',
                 models.ForeignKey(related_name='nears_departure',
                                   verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                                   to='www.Settlement')),
            ],
            options={
                'db_table': 'avia_neardirection',
                'verbose_name': '\u0431\u043b\u0438\u0436\u0430\u0439\u0448\u0438\u0439 \u0430\u044d\u0440\u043e\u043f\u043e\u0440\u0442',
                'verbose_name_plural': '\u0431\u043b\u0438\u0436\u0430\u0439\u0448\u0438\u0435 \u0430\u044d\u0440\u043e\u043f\u043e\u0440\u0442\u044b',
            },
        ),
        migrations.CreateModel(
            name='PartnerReview',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('result',
                 models.CharField(max_length=12,
                                  verbose_name='\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438',
                                  choices=[(b'pass', '\u0423\u0441\u043f\u0435\u0448\u043d\u043e'), (b'problem', '\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u0430'),
                                           (b'error', '\u041e\u0448\u0438\u0431\u043a\u0430')])),
                ('description', TrimmedCharField(default=b'', max_length=255, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
                ('hit_time',
                 models.DateTimeField(
                     verbose_name='\u0412\u0440\u0435\u043c\u044f \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f')),
                ('review_time', models.DateTimeField(verbose_name='\u0412\u0440\u0435\u043c\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438')),
                ('price', models.FloatField(verbose_name='\u0426\u0435\u043d\u0430 \u043d\u0430 \u0432\u044b\u0434\u0430\u0447\u0435')),
                ('price_mbo',
                 models.FloatField(null=True, verbose_name='\u0426\u0435\u043d\u0430 \u043d\u0430 \u0441\u0430\u0439\u0442\u0435 \u043f\u0430\u0440\u0442\u043d\u0451\u0440\u0430', blank=True)),
                ('price_diff_abs',
                 models.FloatField(null=True,
                                   verbose_name='\u0410\u0431\u0441\u043e\u043b\u044e\u0442\u043d\u0430\u044f \u0440\u0430\u0437\u043d\u0438\u0446\u0430 \u0432 \u0446\u0435\u043d\u0435',
                                   blank=True)),
                ('price_diff_rel',
                 models.FloatField(
                     null=True,
                     verbose_name='\u041e\u0442\u043d\u043e\u0441\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0440\u0430\u0437\u043d\u0438\u0446\u0430 \u0432 \u0446\u0435\u043d\u0435, %',
                     blank=True,
                 )),
                ('date_forward', models.DateField(null=True, verbose_name='\u0414\u0430\u0442\u0430 \u0442\u0443\u0434\u0430', blank=True)),
                ('date_backward', models.DateField(null=True, verbose_name='\u0414\u0430\u0442\u0430 \u043e\u0431\u0440\u0430\u0442\u043d\u043e', blank=True)),
                ('adults', models.IntegerField(null=True, verbose_name='\u0412\u0437\u0440\u043e\u0441\u043b\u044b\u0445', blank=True)),
                ('children', models.IntegerField(null=True, verbose_name='\u0414\u0435\u0442\u0435\u0439', blank=True)),
                ('infants', models.IntegerField(null=True, verbose_name='\u041c\u043b\u0430\u0434\u0435\u043d\u0446\u0435\u0432', blank=True)),
                ('order_content', models.TextField(verbose_name='\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0431\u0438\u043b\u0435\u0442\u0430')),
                ('mbo_data', models.TextField(verbose_name='\u041e\u0442\u0432\u0435\u0442 MBO')),
                ('redirect_params', models.TextField(verbose_name='\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430')),
                ('user_info', models.TextField(verbose_name='\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f')),
                ('currency', models.ForeignKey(verbose_name='\u0412\u0430\u043b\u044e\u0442\u0430', blank=True, to='currency.Currency', null=True)),
                ('partner', models.ForeignKey(verbose_name='\u041f\u0430\u0440\u0442\u043d\u0435\u0440', to='order.Partner')),
                ('settlement_from',
                 models.ForeignKey(related_name='partner_review_from',
                                   verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                                   blank=True,
                                   to='www.Settlement',
                                   null=True)),
                ('settlement_to',
                 models.ForeignKey(related_name='partner_review_to',
                                   verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f',
                                   blank=True,
                                   to='www.Settlement',
                                   null=True)),
                ('station_from',
                 models.ForeignKey(related_name='partner_review_from',
                                   verbose_name='\u0421\u0442\u0430\u043d\u0446\u0438\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                                   blank=True,
                                   to='www.Station',
                                   null=True)),
                ('station_to',
                 models.ForeignKey(related_name='partner_review_to',
                                   verbose_name='\u0421\u0442\u0430\u043d\u0446\u0438\u044f \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f',
                                   blank=True,
                                   to='www.Station',
                                   null=True)),
            ],
            options={
                'db_table': 'order_partnerreview',
                'verbose_name': '\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u043f\u0430\u0440\u0442\u043d\u0451\u0440\u0430',
                'verbose_name_plural': '\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0440\u0430\u043d\u0438\u0446 \u043f\u0430\u0440\u0442\u043d\u0451\u0440\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='S7CircuitLimits',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('origin', models.CharField(default=b'', max_length=4, verbose_name='\u041a\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f')),
                ('destination', models.CharField(default=b'', max_length=4, verbose_name='\u041a\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f')),
                ('circuity_limit', models.FloatField(null=True, blank=True)),
                ('duration_ratio', models.FloatField(null=True, blank=True)),
            ],
            options={
                'db_table': 'avia_s7circuitlimits',
                'verbose_name': 'S7: \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u0435\u043c\u0435\u0442\u0440',
                'verbose_name_plural': 'S7: \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0435\u043c\u0435\u0442\u0440\u044b',
            },
        ),
        migrations.CreateModel(
            name='SeoDirection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('publish', models.BooleanField(default=False, verbose_name='\u041e\u043f\u0443\u0431\u043b\u0438\u043a\u043e\u0432\u0430\u0442\u044c')),
                ('text', models.TextField(verbose_name='\u0422\u0435\u043a\u0441\u0442 RU_ru', blank=True)),
                ('text_ua_ru', models.TextField(verbose_name='\u0422\u0435\u043a\u0441\u0442 UA_ru', blank=True)),
                ('text_ua_uk', models.TextField(verbose_name='\u0422\u0435\u043a\u0441\u0442 UA_uk', blank=True)),
                ('point_from', models.ForeignKey(related_name='+', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043e\u0442\u043a\u0443\u0434\u0430', to='www.Settlement')),
                ('point_to', models.ForeignKey(related_name='+', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043a\u0443\u0434\u0430', to='www.Settlement')),
            ],
            options={
                'db_table': 'avia_seodirection',
                'verbose_name': '\u0421\u0435\u043e \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435',
                'verbose_name_plural': '\u0421\u0435\u043e \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
            },
        ),
        migrations.CreateModel(
            name='SimilarDirection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('direction', models.CharField(max_length=15, verbose_name='\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435', db_index=True)),
                ('count', models.PositiveIntegerField(db_index=True)),
                ('similar_from',
                 models.ForeignKey(related_name='+',
                                   verbose_name='\u041f\u043e\u0445\u043e\u0436\u0438\u0439 \u0433\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                                   to='www.Settlement')),
                ('similar_to',
                 models.ForeignKey(related_name='+',
                                   verbose_name='\u041f\u043e\u0445\u043e\u0436\u0438\u0439 \u0433\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f',
                                   to='www.Settlement')),
            ],
            options={
                'ordering': ['-count'],
                'db_table': 'avia_similardirection',
                'verbose_name': '\u043f\u043e\u0445\u043e\u0436\u0435\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435',
                'verbose_name_plural': '\u043f\u043e\u0445\u043e\u0436\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
            },
        ),
        migrations.CreateModel(
            name='TopDirection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('national_version', models.CharField(default=b'ru', max_length=5, verbose_name='\u0422\u0438\u043f', choices=[(b'ru', b'ru'), (b'ua', b'ua'), (b'tr', b'tr'), (b'com', b'com')])),
                ('count', models.PositiveIntegerField(default=0)),
                ('arrival_settlement',
                 models.ForeignKey(related_name='arrival_top_directions', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', to='www.Settlement')),
                ('departure_settlement',
                 models.ForeignKey(related_name='top_directions', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                                   to='www.Settlement')),
            ],
            options={
                'ordering': ('national_version', 'departure_settlement', 'arrival_settlement'),
                'db_table': 'www_topdirection',
                'verbose_name': '\u0422\u043e\u043f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439',
                'verbose_name_plural': '\u0422\u043e\u043f \u043f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u044b\u0445 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='TopFlight',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('from_point_key', models.CharField(max_length=21)),
                ('to_point_key', models.CharField(max_length=21)),
                ('day_of_week', models.SmallIntegerField(choices=[(0, 0), (1, 1), (2, 2), (3, 3), (4, 4), (5, 5), (6, 6)])),
                ('national_version', models.CharField(default=b'ru', max_length=5, verbose_name='\u0422\u0438\u043f', choices=[(b'ru', b'ru'), (b'ua', b'ua'), (b'tr', b'tr'), (b'com', b'com')])),
                ('redirects', models.IntegerField(db_index=True)),
                ('flights', models.CharField(max_length=128, verbose_name='\u0420\u0435\u0439\u0441\u044b')),
            ],
            options={
                'ordering': ('national_version', 'from_point_key', 'to_point_key', 'day_of_week', 'redirects'),
                'db_table': 'tickets_topflight',
                'verbose_name': '\u0422\u043e\u043f \u0440\u0435\u0439\u0441',
                'verbose_name_plural': '\u0422\u043e\u043f \u043f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u044b\u0445 \u0440\u0435\u0439\u0441\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='TourDeparture',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('geo_id', models.IntegerField(verbose_name='Geo ID')),
                ('settlement', models.ForeignKey(related_name='+', verbose_name='\u0413\u043e\u0440\u043e\u0434', to='www.Settlement')),
            ],
            options={
                'db_table': 'avia_tourdeparture',
                'verbose_name': '\u0433\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u0443\u0440\u043e\u0432',
                'verbose_name_plural': '\u0433\u043e\u0440\u043e\u0434\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u0443\u0440\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='TourDestination',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('geo_id', models.IntegerField(verbose_name='Geo ID')),
                ('settlement', models.ForeignKey(related_name='+', verbose_name='\u0413\u043e\u0440\u043e\u0434', to='www.Settlement')),
            ],
            options={
                'db_table': 'avia_tourdestination',
                'verbose_name': '\u0433\u043e\u0440\u043e\u0434 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0442\u0443\u0440\u043e\u0432',
                'verbose_name_plural': '\u0433\u043e\u0440\u043e\u0434\u0430 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0442\u0443\u0440\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='ToursMatrix',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('from_geo_id', models.IntegerField(verbose_name='From Geo ID')),
                ('to_geo_id', models.IntegerField(verbose_name='To Geo ID')),
            ],
            options={
                'db_table': 'avia_toursmatrix',
                'verbose_name': '\u043f\u0435\u0440\u0435\u043b\u0451\u0442 \u0442\u0443\u0440\u043e\u0432',
                'verbose_name_plural': '\u043f\u0435\u0440\u0435\u043b\u0451\u0442\u044b \u0442\u0443\u0440\u043e\u0432',
            },
        ),
        migrations.AlterUniqueTogether(
            name='toursmatrix',
            unique_together=set([('from_geo_id', 'to_geo_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='topflight',
            unique_together=set([('national_version', 'from_point_key', 'to_point_key', 'day_of_week', 'redirects', 'flights')]),
        ),
        migrations.AlterUniqueTogether(
            name='s7circuitlimits',
            unique_together=set([('origin', 'destination')]),
        ),
        migrations.AddField(
            model_name='flightreview',
            name='source',
            field=models.ForeignKey(related_name='avia_data_flightreview_source', verbose_name='\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a', to='avia_data.FlightReviewSource'),
        ),
        migrations.AddField(
            model_name='flightreview',
            name='station_from',
            field=models.ForeignKey(
                related_name='avia_data_flightreview_station_from',
                verbose_name='\u0421\u0442\u0430\u043d\u0446\u0438\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                blank=True,
                to='www.Station',
                null=True,
            ),
        ),
        migrations.AddField(
            model_name='flightreview',
            name='station_to',
            field=models.ForeignKey(related_name='avia_data_flightreview_station_to',
                                    verbose_name='\u0421\u0442\u0430\u043d\u0446\u0438\u044f \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f',
                                    blank=True,
                                    to='www.Station',
                                    null=True),
        ),
        migrations.AlterUniqueTogether(
            name='flightrating',
            unique_together=set([('number', 'avg_scores')]),
        ),
        migrations.AddField(
            model_name='bestoffers',
            name='currency',
            field=models.ForeignKey(related_name='+', verbose_name='\u0412\u0430\u043b\u044e\u0442\u0430', to='currency.Currency', null=True),
        ),
        migrations.AddField(
            model_name='avgprice',
            name='currency',
            field=models.ForeignKey(related_name='avg_price_currency', verbose_name='\u0412\u0430\u043b\u044e\u0442\u0430', to='currency.Currency', db_index=False),
        ),
        migrations.AddField(
            model_name='avgprice',
            name='departure_settlement',
            field=models.ForeignKey(related_name='avg_price_departure_settlement',
                                    verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                                    to='www.Settlement',
                                    db_index=False),
        ),
        migrations.AlterUniqueTogether(
            name='topdirection',
            unique_together=set([('national_version', 'departure_settlement', 'arrival_settlement')]),
        ),
        migrations.AlterUniqueTogether(
            name='minprice',
            unique_together=set([('national_version', 'departure_settlement', 'arrival_settlement', 'date_forward')]),
        ),
        migrations.AlterUniqueTogether(
            name='mincountryprice',
            unique_together=set([('national_version', 'departure_country', 'arrival_country', 'date_forward', 'date_backward', 'passengers', 'direct_flight')]),
        ),
        migrations.AlterUniqueTogether(
            name='companytariff',
            unique_together=set([('avia_company', 'mask')]),
        ),
        migrations.AlterUniqueTogether(
            name='aviawizarddirection',
            unique_together=set([('settlement_1', 'settlement_2')]),
        ),
        migrations.AlterUniqueTogether(
            name='aviasettlementnational',
            unique_together=set([('national_version', 'settlement', 'arrival')]),
        ),
        migrations.AlterUniqueTogether(
            name='aviasettlement',
            unique_together=set([('settlement', 'arrival')]),
        ),
        migrations.AlterUniqueTogether(
            name='aviadirectionnational',
            unique_together=set([('national_version', 'departure_settlement', 'arrival_settlement')]),
        ),
        migrations.AlterUniqueTogether(
            name='aviadirection',
            unique_together=set([('departure_settlement', 'arrival_settlement')]),
        ),
        migrations.AlterUniqueTogether(
            name='avgprice',
            unique_together=set([('national_version', 'departure_settlement', 'arrival_settlement', 'month_forward', 'year_forward', 'month_backward', 'year_backward', 'direct_flight', 'passengers')
                                 ]),
        ),
    ]
