# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
from travel.avia.library.python.common.utils.fields import TrimmedCharField
from travel.avia.library.python.common.models.partner import PartnerLogoFileSystemStorage
from travel.avia.library.python.avia_data.models import amadeus_merchant


class Migration(migrations.Migration):

    dependencies = [
        ('avia_data', '0010_new_upper_bound_for_merchant_variant_cache_time'),
    ]

    operations = [
        migrations.AddField(
            model_name='amadeusmerchant',
            name='description_kz_ru',
            field=models.TextField(
                null=True,
                verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (ru)',
                blank=True,
            ),
        ),
        migrations.AddField(
            model_name='amadeusmerchant',
            name='enabled_in_mobile_ticket_kz',
            field=models.BooleanField(
                default=False,
                verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041a\u0411 (kz)',
            ),
        ),
        migrations.AddField(
            model_name='amadeusmerchant',
            name='enabled_in_ticket_kz',
            field=models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041a\u0411 (kz)'),
        ),
        migrations.AddField(
            model_name='amadeusmerchant',
            name='logo_svg2png_kz',
            field=amadeus_merchant.CustomImageField(
                default=None, storage=PartnerLogoFileSystemStorage(),
                upload_to=amadeus_merchant.UploadToGetter(b'partners/svg2png', b'amadeus', b'kz', b'png'),
                blank=True, null=True,
                verbose_name='\u0420\u0435\u043d\u0434\u0435\u0440\u0435\u043d\u043d\u044b\u0439 svg2png \u043b\u043e\u0433\u043e\u0442\u0438\u043f kz \u0432\u0435\u0440\u0441\u0438\u0438',
            ),
        ),
        migrations.AddField(
            model_name='amadeusmerchant',
            name='logo_svg_kz',
            field=amadeus_merchant.SvgImageField(
                default=None, storage=PartnerLogoFileSystemStorage(),
                upload_to=amadeus_merchant.UploadToGetter(b'partners/svg', b'amadeus', b'kz', b'svg'),
                blank=True, null=True,
                verbose_name='\u0426\u0432\u0435\u0442\u043d\u043e\u0439 \u043b\u043e\u0433\u043e\u0442'
                             '\u0438\u043f kz \u0432\u0435\u0440\u0441\u0438\u0438 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 svg',
            ),
        ),
        migrations.AddField(
            model_name='amadeusmerchant',
            name='national_kz_title_en',
            field=TrimmedCharField(
                default='', max_length=100, null=True,
                verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (en)',
                blank=True,
            ),
        ),
        migrations.AddField(
            model_name='amadeusmerchant',
            name='national_kz_title_ru',
            field=TrimmedCharField(
                default='', max_length=100, null=True,
                verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (ru)',
                blank=True,
            ),
        ),
        migrations.AddField(
            model_name='amadeusmerchant',
            name='national_kz_title_tr',
            field=TrimmedCharField(
                default='', max_length=100, null=True,
                verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (tr)',
                blank=True,
            ),
        ),
        migrations.AddField(
            model_name='amadeusmerchant',
            name='national_kz_title_uk',
            field=TrimmedCharField(
                default='', max_length=100, null=True,
                verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (uk)',
                blank=True,
            ),
        ),
        migrations.AddField(
            model_name='aviarecipe',
            name='enabled_kz',
            field=models.BooleanField(default=False, verbose_name='\u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c (kz)'),
        ),
    ]
