# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('order', '0026_change-partneruser-role-length'),
        ('avia_data', '0013_del_deprecated'),
    ]

    operations = [
        migrations.CreateModel(
            name='BalanceRedirect',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('billing_order_id', models.PositiveIntegerField()),
                ('eventdate', models.DateField()),
                ('eventtime', models.TimeField()),
                ('filtered', models.BooleanField(db_index=True)),
                ('filter_name', models.CharField(max_length=32, null=True, blank=True)),
                ('host', models.CharField(max_length=32)),
                ('national_version', models.CharField(default=b'ru', max_length=5, verbose_name='\u041d\u0430\u0446. \u0432\u0435\u0440\u0441\u0438\u044f',
                 choices=[(b'ru', b'ru'), (b'ua', b'ua'), (b'tr', b'tr'), (b'com', b'com'), (b'kz', b'kz')])),
                ('pp', models.PositiveIntegerField(db_index=True)),
                ('show_id', models.CharField(max_length=32)),
                ('yandexuid', models.CharField(max_length=32, null=True, blank=True)),
                ('partner', models.ForeignKey(related_name='+', verbose_name='\u041f\u0430\u0440\u043d\u0435\u0440', blank=True, to='order.Partner', null=True)),
            ],
            options={
                'db_table': 'avia_balanceredirect',
                'verbose_name': '\u041a\u043b\u0438\u043a \u043f\u043e\u0441\u043b\u0435 \u0430\u043d\u0442\u0438\u0444\u0440\u043e\u0434\u0430',
                'verbose_name_plural': '\u041a\u043b\u0438\u043a\u0438 \u043f\u043e\u0441\u043b\u0435 \u0430\u043d\u0442\u0438\u0444\u0440\u043e\u0434\u0430',
            },
        ),
        migrations.AlterIndexTogether(
            name='balanceredirect',
            index_together=set([('eventdate', 'pp'), ('eventdate', 'partner', 'national_version', 'pp'), ('eventdate', 'national_version', 'pp')]),
        ),
    ]
