# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0007_merge'),
        ('order', '0027_change_partneruser_role_length'),
        ('avia_data', '0013_del_deprecated'),
    ]

    operations = [
        migrations.CreateModel(
            name='SelfBookCompany',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('company', models.ForeignKey(related_name='+', verbose_name='\u041a\u043e\u043c\u043f\u0430\u043d\u0438\u044f', to='www.Company')),
            ],
            options={
                'db_table': 'avia_selfbookcompany',
                'verbose_name': '\u041a\u043e\u043c\u043f\u0430\u043d\u0438\u044f \u043f\u0440\u0430\u0432\u0438\u043b\u0430 selfbook',
                'verbose_name_plural': '\u041a\u043e\u043c\u043f\u0430\u043d\u0438\u0438 \u043f\u0440\u0430\u0432\u0438\u043b\u0430 selfbook',
            },
        ),
        migrations.CreateModel(
            name='SelfBookDirection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('country_from', models.ForeignKey(
                    related_name='+',
                    verbose_name='\u0421\u0442\u0440\u0430\u043d\u0430 \u043e\u0442\u043a\u0443\u0434\u0430',
                    blank=True, to='www.Country', null=True,
                )),
                ('country_to', models.ForeignKey(related_name='+', verbose_name='\u0421\u0442\u0440\u0430\u043d\u0430 \u043a\u0443\u0434\u0430', blank=True, to='www.Country', null=True)),
            ],
            options={
                'db_table': 'avia_selfbookdirection',
                'verbose_name': '\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u0430 selfbook',
                'verbose_name_plural': '\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0440\u0430\u0432\u0438\u043b\u0430 selfbook',
            },
        ),
        migrations.CreateModel(
            name='SelfBookPartner',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('partner', models.ForeignKey(related_name='+', verbose_name='\u041f\u0430\u0440\u0442\u043d\u0451\u0440', to='order.Partner')),
            ],
            options={
                'db_table': 'avia_selfbookpartner',
                'verbose_name': '\u041f\u0430\u0440\u0442\u043d\u0451\u0440 \u043f\u0440\u0430\u0432\u0438\u043b\u0430 selfbook',
                'verbose_name_plural': '\u041f\u0430\u0440\u0442\u043d\u0451\u0440\u044b \u043f\u0440\u0430\u0432\u0438\u043b\u0430 selfbook',
            },
        ),
        migrations.CreateModel(
            name='SelfBookRule',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('description', models.CharField(max_length=255, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435')),
                ('exclude_partners', models.BooleanField(verbose_name='\u041a\u0440\u043e\u043c\u0435 \u043f\u0430\u0440\u0442\u043d\u0451\u0440\u043e\u0432')),
                ('exclude_companies', models.BooleanField(verbose_name='\u041a\u0440\u043e\u043c\u0435 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0439')),
                ('exclude_directions', models.BooleanField(verbose_name='\u041a\u0440\u043e\u043c\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439')),
            ],
            options={
                'db_table': 'avia_selfbookrule',
                'verbose_name': '\u041f\u0440\u0430\u0432\u0438\u043b\u043e selfbook',
                'verbose_name_plural': '\u041f\u0440\u0430\u0432\u0438\u043b\u0430 selfbook',
            },
        ),
        migrations.AddField(
            model_name='selfbookpartner',
            name='rule',
            field=models.ForeignKey(
                related_name='+', verbose_name='\u041f\u0440\u0430\u0432\u0438\u043b\u043e selfbook \u0434\u043b\u044f \u043f\u0430\u0440\u0442\u043d\u0451\u0440\u0430', to='avia_data.SelfBookRule'),
        ),
        migrations.AddField(
            model_name='selfbookdirection',
            name='rule',
            field=models.ForeignKey(
                related_name='+',
                verbose_name='\u041f\u0440\u0430\u0432\u0438\u043b\u043e selfbook \u0434\u043b\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                to='avia_data.SelfBookRule',
            ),
        ),
        migrations.AddField(
            model_name='selfbookdirection',
            name='settlement_from',
            field=models.ForeignKey(related_name='+', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043e\u0442\u043a\u0443\u0434\u0430', blank=True, to='www.Settlement', null=True),
        ),
        migrations.AddField(
            model_name='selfbookdirection',
            name='settlement_to',
            field=models.ForeignKey(related_name='+', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043a\u0443\u0434\u0430', blank=True, to='www.Settlement', null=True),
        ),
        migrations.AddField(
            model_name='selfbookdirection',
            name='station_from',
            field=models.ForeignKey(related_name='+', verbose_name='\u0410\u044d\u0440\u043e\u043f\u043e\u0440\u0442 \u043e\u0442\u043a\u0443\u0434\u0430', blank=True, to='www.Station', null=True),
        ),
        migrations.AddField(
            model_name='selfbookdirection',
            name='station_to',
            field=models.ForeignKey(related_name='+', verbose_name='\u0410\u044d\u0440\u043e\u043f\u043e\u0440\u0442 \u043a\u0443\u0434\u0430', blank=True, to='www.Station', null=True),
        ),
        migrations.AddField(
            model_name='selfbookcompany',
            name='rule',
            field=models.ForeignKey(
                related_name='+', verbose_name='\u041f\u0440\u0430\u0432\u0438\u043b\u043e selfbook \u0434\u043b\u044f \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438', to='avia_data.SelfBookRule'),
        ),
        migrations.AlterUniqueTogether(
            name='selfbookpartner',
            unique_together=set([('rule', 'partner')]),
        ),
        migrations.AlterUniqueTogether(
            name='selfbookdirection',
            unique_together=set([('rule', 'station_from', 'settlement_from', 'country_from', 'station_to', 'settlement_to', 'country_to')]),
        ),
        migrations.AlterUniqueTogether(
            name='selfbookcompany',
            unique_together=set([('rule', 'company')]),
        ),
    ]
