# -*- coding: utf-8 -*-
from __future__ import unicode_literals
import json
import os

from django.db import migrations


def fill_url2(apps, schema_editor):
    AdminSettlementBigImage = apps.get_model('avia_data', 'adminsettlementbigimage')
    data_file = os.path.join(os.path.dirname(__file__), 'data/avatar_urls.json')

    with open(data_file) as f:
        urls = json.load(f)

    for image in AdminSettlementBigImage.objects.all():
        image.url2 = urls.get(image.url, '')
        image.save()


def clear_url2(apps, schema_editor):
    AdminSettlementBigImage = apps.get_model('avia_data', 'adminsettlementbigimage')

    for image in AdminSettlementBigImage.objects.all():
        image.url2 = ''
        image.save()


class Migration(migrations.Migration):

    dependencies = [
        ('avia_data', '0020_adminsettlementbigimage_url2'),
    ]

    operations = [
        migrations.RunPython(fill_url2, reverse_code=clear_url2),
    ]
