# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations


def fill_nationalversion(apps, schema_editor):
    NationalVersion = apps.get_model("avia_data", "NationalVersion")

    for code, name in [
        ('ru', 'Российская'),
        ('ua', 'Украинская'),
        ('kz', 'Казахская'),
        ('com', 'Международная'),
        ('tr', 'Турецкая'),
    ]:
        NationalVersion.objects.create(code=code, name=name)


class Migration(migrations.Migration):

    dependencies = [
        ('avia_data', '0024_nationalversion'),
    ]

    operations = [
        migrations.RunPython(fill_nationalversion),
    ]
