# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('avia_data', '0026_selfbooknationalversion'),
    ]

    operations = [
        migrations.CreateModel(
            name='GoodPrice',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('point_from_type', models.CharField(
                    max_length=1, verbose_name='\u0422\u0438\u043f \u043f\u0443\u043d\u043a\u0442\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                )),
                ('point_from_id', models.PositiveIntegerField(
                    verbose_name='\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 '
                                 '\u043f\u0443\u043d\u043a\u0442\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                )),
                ('point_to_type', models.CharField(
                    max_length=1, verbose_name='\u0422\u0438\u043f \u043f\u0443\u043d\u043a\u0442\u0430 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f',
                )),
                ('point_to_id', models.PositiveIntegerField(
                    verbose_name='\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u0443\u043d\u043a\u0442\u0430 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f',
                )),
                ('route_uid', models.CharField(
                    max_length=200, verbose_name='\u041d\u043e\u043c\u0435\u0440\u0430 \u0440\u0435\u0439\u0441\u043e\u0432',
                )),
                ('departure_weekday', models.PositiveSmallIntegerField(
                    verbose_name='\u0414\u0435\u043d\u044c \u043d\u0435\u0434\u0435\u043b\u0438 \u0432\u044b\u043b\u0435\u0442\u0430',
                    choices=[(0, 0), (1, 1), (2, 2), (3, 3), (4, 4), (5, 5), (6, 6)],
                )),
                ('days_to_flight', models.IntegerField(verbose_name='\u0414\u043d\u0435\u0439 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430')),
                ('q33', models.FloatField(verbose_name='33 \u043f\u0435\u0440\u0446\u0435\u043d\u0442\u0438\u043b\u044c')),
                ('q67', models.FloatField(verbose_name='67 \u043f\u0435\u0440\u0446\u0435\u043d\u0442\u0438\u043b\u044c')),
            ],
            options={
                'db_table': 'avia_goodprice',
                'verbose_name': '\u0445\u043e\u0440\u043e\u0448\u0430\u044f \u0446\u0435\u043d\u0430',
                'verbose_name_plural': '\u0445\u043e\u0440\u043e\u0448\u0438\u0435 \u0446\u0435\u043d\u044b',
            },
        ),
        migrations.AlterUniqueTogether(
            name='goodprice',
            unique_together=set([('point_from_type', 'point_from_id', 'point_to_type', 'point_to_id', 'departure_weekday', 'days_to_flight', 'route_uid')]),
        ),
    ]
