# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations


def strip_size_suffix(apps, schema_editor):
    AdminSettlementBigImage = apps.get_model('avia_data', 'adminsettlementbigimage')

    for image in AdminSettlementBigImage.objects.all():
        if image.url2 and image.url2.url.endswith('/orig'):
            image.url2 = image.url2.url[:-5]
            image.save()


def noop(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('avia_data', '0033_default_update_time'),
    ]

    operations = [
        migrations.RunPython(strip_size_suffix, reverse_code=noop),
    ]
