# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations

from travel.avia.library.python.common.models.transport import TransportType


def fill_airports_tablo_source(apps, schema_editor):
    AirportTabloSource = apps.get_model('avia_data', 'AirportTabloSource')
    Station = apps.get_model('www', 'Station')

    for station in Station.objects.filter(t_type=TransportType.PLANE_ID):
        AirportTabloSource.objects.get_or_create(station=station)


class Migration(migrations.Migration):

    dependencies = [
        ('avia_data', '0036_create_tablo_source'),
    ]

    operations = [
        migrations.RunPython(fill_airports_tablo_source),
    ]
