# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


def _create_settings(apps, schema_editor):
    WizardSetting = apps.get_model('avia_data', 'WizardSetting')
    WizardSetting(enabled=True, dynamic_pp=True).save()


def noop(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('avia_data', '0043_avia_recipe_backward_dates'),
    ]

    operations = [
        migrations.CreateModel(
            name='WizardSetting',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('enabled', models.BooleanField(default=True, verbose_name='\u0412\u043a\u043b\u044e\u0447\u0451\u043d')),
                ('dynamic_pp', models.BooleanField(
                    default=True,
                    verbose_name='\u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0442\u044c '
                                 '\u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0443\u044e \u0432\u044b\u0434\u0430\u0447\u0443',
                )),
            ],
            options={
                'db_table': 'settings_wizard',
                'verbose_name': '\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043a\u043e\u043b\u0434\u0443\u043d\u0449\u0438\u043a\u0430',
                'verbose_name_plural': '\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043a\u043e\u043b\u0434\u0443\u043d\u0449\u0438\u043a\u0430',
            },
        ),
        migrations.RunPython(_create_settings, reverse_code=noop),
    ]
