# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import json

import os
from django.db import migrations

from travel.avia.library.python.common.models.transport import TransportType


def fill_airports_tablo_source(apps, schema_editor):
    AviaCompany = apps.get_model('avia_data', 'AviaCompany')
    Company = apps.get_model('www', 'Company')
    data_file = os.path.join(os.path.dirname(__file__), 'data', '0048_company_iatas.json')

    with open(data_file) as f:
        iata_by_company_id = dict(json.load(f))

    for company in Company.objects.filter(t_type=TransportType.PLANE_ID):
        ac, created = AviaCompany.objects.get_or_create(rasp_company_id=company.id)
        ac.iata = iata_by_company_id.get(company.id)
        ac.save()


class Migration(migrations.Migration):

    dependencies = [
        ('avia_data', '0047_add_aviacompany_iata'),
    ]

    operations = [
        migrations.RunPython(fill_airports_tablo_source),
    ]
