# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
from travel.avia.library.python.avia_data import storage
from travel.avia.library.python.common.utils.media_fields import CustomImageField, SvgImageField
from travel.avia.library.python.common.utils.fields import CodeCharField
from travel.avia.library.python.common.models.base_partner_model import PartnerLogoFileSystemStorage


class Migration(migrations.Migration):

    dependencies = [
        ('avia_data', '0065_add_nationalversion_query_param'),
    ]

    operations = [
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='code',
            field=CodeCharField(
                null=True, default=None, max_length=100, blank=True, unique=True,
                verbose_name='\u043a\u043e\u0434 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430',
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='logo2_svg2png_com',
            field=CustomImageField(
                default=None, storage=storage.AvatarsPngStorage(), upload_to=b'', blank=True, null=True,
                verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (com) \u0432 \u0410\u0432\u0430\u0442\u0430\u0440\u043d\u0438\u0446\u0435',
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='logo2_svg2png_kz',
            field=CustomImageField(
                default=None, storage=storage.AvatarsPngStorage(), upload_to=b'', blank=True, null=True,
                verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (kz) \u0432 \u0410\u0432\u0430\u0442\u0430\u0440\u043d\u0438\u0446\u0435',
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='logo2_svg2png_ru',
            field=CustomImageField(
                default=None, storage=storage.AvatarsPngStorage(), upload_to=b'', blank=True, null=True,
                verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (ru) \u0432 \u0410\u0432\u0430\u0442\u0430\u0440\u043d\u0438\u0446\u0435',
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='logo2_svg2png_tr',
            field=CustomImageField(
                default=None, storage=storage.AvatarsPngStorage(), upload_to=b'', blank=True, null=True,
                verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (tr) \u0432 \u0410\u0432\u0430\u0442\u0430\u0440\u043d\u0438\u0446\u0435',
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='logo2_svg2png_ua',
            field=CustomImageField(
                default=None, storage=storage.AvatarsPngStorage(), upload_to=b'', blank=True, null=True,
                verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (ua) \u0432 \u0410\u0432\u0430\u0442\u0430\u0440\u043d\u0438\u0446\u0435',
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='logo2_svg_com',
            field=SvgImageField(
                default=b'', upload_to=b'', storage=storage.AvatarsSvgStorage(),
                verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (com) \u0432 \u0410\u0432\u0430\u0442\u0430\u0440\u043d\u0438\u0446\u0435', blank=True,
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='logo2_svg_kz',
            field=SvgImageField(
                default=b'', upload_to=b'', storage=storage.AvatarsSvgStorage(),
                verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (kz) \u0432 \u0410\u0432\u0430\u0442\u0430\u0440\u043d\u0438\u0446\u0435', blank=True,
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='logo2_svg_ru',
            field=SvgImageField(
                default=b'', upload_to=b'', storage=storage.AvatarsSvgStorage(),
                verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (ru) \u0432 \u0410\u0432\u0430\u0442\u0430\u0440\u043d\u0438\u0446\u0435', blank=True,
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='logo2_svg_tr',
            field=SvgImageField(
                default=b'', upload_to=b'', storage=storage.AvatarsSvgStorage(),
                verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (tr) \u0432 \u0410\u0432\u0430\u0442\u0430\u0440\u043d\u0438\u0446\u0435', blank=True,
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='logo2_svg_ua',
            field=SvgImageField(
                default=b'', upload_to=b'', storage=storage.AvatarsSvgStorage(),
                verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (ua) \u0432 \u0410\u0432\u0430\u0442\u0430\u0440\u043d\u0438\u0446\u0435', blank=True,
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='logo_svg2png_com',
            field=CustomImageField(
                default=None, storage=PartnerLogoFileSystemStorage(), upload_to=None, blank=True, null=True,
                verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (com)',
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='logo_svg2png_kz',
            field=CustomImageField(
                default=None, storage=PartnerLogoFileSystemStorage(), upload_to=None, blank=True, null=True,
                verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (kz)',
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='logo_svg2png_ru',
            field=CustomImageField(
                default=None, storage=PartnerLogoFileSystemStorage(), upload_to=None, blank=True, null=True,
                verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (ru)',
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='logo_svg2png_tr',
            field=CustomImageField(
                default=None, storage=PartnerLogoFileSystemStorage(), upload_to=None, blank=True, null=True,
                verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (tr)',
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='logo_svg2png_ua',
            field=CustomImageField(
                default=None, storage=PartnerLogoFileSystemStorage(), upload_to=None, blank=True, null=True,
                verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (ua)',
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='logo_svg_com',
            field=SvgImageField(
                default=None, storage=PartnerLogoFileSystemStorage(), upload_to=None, blank=True, null=True,
                verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (com)',
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='logo_svg_kz',
            field=SvgImageField(
                default=None, storage=PartnerLogoFileSystemStorage(), upload_to=None, blank=True, null=True,
                verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (kz)',
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='logo_svg_ru',
            field=SvgImageField(
                default=None, storage=PartnerLogoFileSystemStorage(), upload_to=None, blank=True, null=True,
                verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (ru)',
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='logo_svg_tr',
            field=SvgImageField(
                default=None, storage=PartnerLogoFileSystemStorage(), upload_to=None, blank=True, null=True,
                verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (tr)',
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='logo_svg_ua',
            field=SvgImageField(
                default=None, storage=PartnerLogoFileSystemStorage(), upload_to=None, blank=True, null=True,
                verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (ua)',
            ),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='review_percent',
            field=models.IntegerField(default=10, verbose_name='\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u043f\u0440\u043e\u0432\u0435\u0440\u043e\u043a'),
        ),
        migrations.AlterField(
            model_name='amadeusmerchant',
            name='site_url',
            field=models.CharField(max_length=255, null=True, verbose_name='\u0441\u0430\u0439\u0442 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430'),
        ),
    ]
