# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


def update_pricing_model(apps, schema_editor):
    amadeusmerchant = apps.get_model('avia_data', 'amadeusmerchant')
    for partner in amadeusmerchant.objects.all():
        partner.pricing_model = 'cpa'
        partner.save()


class Migration(migrations.Migration):

    dependencies = [
        ('avia_data', '0067_auto_20190903_2108'),
    ]

    operations = [
        migrations.AddField(
            model_name='amadeusmerchant',
            name='pricing_model',
            field=models.CharField(
                default=b'cpc', max_length=5, null=True,
                verbose_name='\u041c\u043e\u0434\u0435\u043b\u044c \u0446\u0435\u043d\u043e\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f',
                choices=[(b'cpc', b'cpc'), (b'cpa', b'cpa')],
            ),
        ),
        migrations.RunPython(
            update_pricing_model
        ),
    ]
