# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations


class Migration(migrations.Migration):

    dependencies = [
        ('avia_data', '0076_auto_20200611_1019'),
    ]

    create_procedure_sql = '''
        CREATE PROCEDURE add_on_cascade_to_referrers(target_table_name CHAR(64), target_column_name CHAR(64))
        BEGIN

            DECLARE referrer_table char(64) DEFAULT NULL;
            DECLARE referrer_table_fk char(64) DEFAULT NULL;
            DECLARE referrer_table_constraint char(64) DEFAULT NULL;

            DECLARE done TINYINT DEFAULT FALSE;

            DECLARE referrer_table_fetcher
                CURSOR FOR
                SELECT TABLE_NAME, COLUMN_NAME, CONSTRAINT_NAME
                FROM information_schema.KEY_COLUMN_USAGE
                WHERE REFERENCED_TABLE_NAME = target_table_name
                  AND REFERENCED_COLUMN_NAME = target_column_name
                  AND CONSTRAINT_SCHEMA = DATABASE();

            # catch exception when cursour runs out of rows
            DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;

            OPEN referrer_table_fetcher;

            offset_loop:
            LOOP

                FETCH NEXT FROM referrer_table_fetcher INTO referrer_table, referrer_table_fk, referrer_table_constraint;
                SELECT concat(referrer_table, ' ', referrer_table_fk, ' ', referrer_table_constraint);
                IF done THEN
                    LEAVE offset_loop;
                ELSE
                    # prepared statements are used as a way to pass things like table name to query.
                    SET @query = CONCAT('ALTER TABLE ', referrer_table, ' DROP FOREIGN KEY ', referrer_table_constraint, ';');
                    PREPARE statement FROM @query;
                    EXECUTE statement;
                    DEALLOCATE PREPARE statement;

                    SET @query = CONCAT(' ALTER TABLE ', referrer_table, ' ADD CONSTRAINT ', referrer_table_constraint,
                                        ' FOREIGN KEY (', referrer_table_fk, ') ', ' REFERENCES ', target_table_name, '(', target_column_name,
                                        ')', ' ON UPDATE CASCADE;');
                    PREPARE statement FROM @query;
                    EXECUTE statement;
                    DEALLOCATE PREPARE statement;

                END IF;

            END LOOP;

        END;
    '''

    operations = [
        migrations.RunSQL('DROP PROCEDURE IF EXISTS add_on_cascade_to_referrers;'),
        migrations.RunSQL(create_procedure_sql),
    ]
