# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations


class Migration(migrations.Migration):
    dependencies = [
        ('avia_data', '0077_fix-add_on_cascade_to_referers'),
        ('www', '0037_add-foreign-key-from-www_stationcode-to-www_station'),
    ]

    create_add_missing_foreign_key_constraints_to_www_station_procedure = '''
        CREATE PROCEDURE add_missing_foreign_key_constraints_to_www_station()
        BEGIN
            DECLARE referrer_table char(64) DEFAULT NULL;
            DECLARE referrer_table_fk char(64) DEFAULT NULL;
            DECLARE done TINYINT DEFAULT FALSE;
            DECLARE is_nullable TINYINT DEFAULT FALSE;
            DECLARE referrer_table_fetcher
                CURSOR FOR
                select table_name, column_name, is_nullable  from information_schema.columns  where
                column_name regexp '^(.+_)?station(_from|_to)?_idx?$'
                    and table_schema = DATABASE()
                and table_name not in
                  (     select table_name
                  FROM information_schema.KEY_COLUMN_USAGE
                  WHERE          REFERENCED_TABLE_NAME = "www_station"
                  AND REFERENCED_COLUMN_NAME = "id"
                  AND CONSTRAINT_SCHEMA = DATABASE() );
            DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;
            OPEN referrer_table_fetcher;
            offset_loop:
            LOOP
                FETCH NEXT FROM referrer_table_fetcher INTO referrer_table, referrer_table_fk, is_nullable;
                SELECT concat(referrer_table, ' ', referrer_table_fk);
                IF done THEN
                    LEAVE offset_loop;
                ELSE
                    IF is_nullable THEN
                        SET @query = CONCAT(' UPDATE ', referrer_table, ' SET ', referrer_table_fk,
                                            '=NULL WHERE ', referrer_table_fk, ' NOT IN (SELECT id from www_station)');
                        PREPARE statement FROM @query;
                        EXECUTE statement;
                        DEALLOCATE PREPARE statement;

                    ELSE
                        SET @query = CONCAT(' DELETE FROM ', referrer_table, ' WHERE ', referrer_table_fk,
                                            ' NOT IN (SELECT id from www_station)');
                        PREPARE statement FROM @query;
                        EXECUTE statement;
                        DEALLOCATE PREPARE statement;

                    END IF;
                    SET @query = CONCAT(' ALTER TABLE ', referrer_table, ' ADD CONSTRAINT ',
                                        ' FOREIGN KEY (', referrer_table_fk, ') ', ' REFERENCES www_station  (id)
                                        ON UPDATE CASCADE ON DELETE CASCADE;');
                    PREPARE statement FROM @query;
                    EXECUTE statement;
                    DEALLOCATE PREPARE statement;
                END IF;
            END LOOP;
        END;
    '''

    operations = [
        migrations.RunSQL('DROP PROCEDURE IF EXISTS add_missing_foreign_key_constraints_to_www_station'),
        migrations.RunSQL(create_add_missing_foreign_key_constraints_to_www_station_procedure),
        migrations.RunSQL('CALL add_missing_foreign_key_constraints_to_www_station()'),
        migrations.RunSQL('DROP PROCEDURE IF EXISTS add_missing_foreign_key_constraints_to_www_station'),
    ]
