# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
from django.conf import settings
from travel.avia.library.python.common.utils.fields import CodeCharField, TrimmedCharField
import django.core.validators


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0046_fix_id_intersection'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('avia_data', '0078_add_missing_foreign_key_constraints'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalAmadeusMerchant',
            fields=[
                ('id', models.IntegerField(verbose_name='ID', db_index=True, auto_created=True, blank=True)),
                ('site_url', models.CharField(max_length=255, null=True, verbose_name='\u0441\u0430\u0439\u0442 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430')),
                ('code', CodeCharField(default=None, max_length=100, blank=True, null=True, verbose_name='\u043a\u043e\u0434 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430', db_index=True)),  # noqa
                ('review_percent', models.IntegerField(default=10, verbose_name='\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u043f\u0440\u043e\u0432\u0435\u0440\u043e\u043a \u043f\u043e-\u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e')),  # noqa
                ('review_percent_ru', models.IntegerField(null=True, verbose_name='\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u043f\u0440\u043e\u0432\u0435\u0440\u043e\u043a \u0434\u043b\u044f ru', blank=True)),  # noqa
                ('review_percent_kz', models.IntegerField(null=True, verbose_name='\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u043f\u0440\u043e\u0432\u0435\u0440\u043e\u043a \u0434\u043b\u044f kz', blank=True)),  # noqa
                ('review_percent_ua', models.IntegerField(null=True, verbose_name='\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u043f\u0440\u043e\u0432\u0435\u0440\u043e\u043a \u0434\u043b\u044f ua', blank=True)),  # noqa
                ('review_percent_com', models.IntegerField(null=True, verbose_name='\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u043f\u0440\u043e\u0432\u0435\u0440\u043e\u043a \u0434\u043b\u044f com', blank=True)),  # noqa
                ('review_percent_tr', models.IntegerField(null=True, verbose_name='\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u043f\u0440\u043e\u0432\u0435\u0440\u043e\u043a \u0434\u043b\u044f tr', blank=True)),  # noqa
                ('is_aviacompany', models.BooleanField(default=False, verbose_name='\u0410\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f')),
                ('enabled_in_ticket_ru', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041a\u0411 (ru)')),
                ('enabled_in_ticket_ua', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041a\u0411 (ua)')),
                ('enabled_in_ticket_kz', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041a\u0411 (kz)')),
                ('enabled_in_ticket_tr', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041a\u0411 (tr)')),
                ('enabled_in_ticket_com', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041a\u0411 (com)')),
                ('enabled_in_rasp_ru', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041f\u041c (ru)')),
                ('enabled_in_rasp_ua', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041f\u041c (ua)')),
                ('enabled_in_rasp_kz', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041f\u041c (kz)')),
                ('enabled_in_rasp_tr', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041f\u041c (tr)')),
                ('enabled_in_mobile_ticket_ru', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041a\u0411 (ru)')),  # noqa
                ('enabled_in_mobile_ticket_ua', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041a\u0411 (ua)')),  # noqa
                ('enabled_in_mobile_ticket_kz', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041a\u0411 (kz)')),  # noqa
                ('enabled_in_mobile_ticket_tr', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041a\u0411 (tr)')),  # noqa
                ('enabled_in_mobile_ticket_com', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041a\u0411 (com)')),  # noqa
                ('enabled_in_mobile_rasp_ru', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041f\u041c (ru)')),  # noqa
                ('enabled_in_mobile_rasp_ua', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041f\u041c (ua)')),  # noqa
                ('enabled_in_mobile_rasp_kz', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041f\u041c (kz)')),  # noqa
                ('enabled_in_mobile_rasp_tr', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041f\u041c (tr)')),  # noqa
                ('enabled_in_wizard_ru', models.BooleanField(default=True, verbose_name='\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0432 \u043a\u043e\u043b\u0434\u0443\u043d\u0449\u0438\u043a\u0435 (ru)')),  # noqa
                ('enabled_in_wizard_ua', models.BooleanField(default=True, verbose_name='\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0432 \u043a\u043e\u043b\u0434\u0443\u043d\u0449\u0438\u043a\u0435 (ua)')),  # noqa
                ('enabled_in_wizard_kz', models.BooleanField(default=True, verbose_name='\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0432 \u043a\u043e\u043b\u0434\u0443\u043d\u0449\u0438\u043a\u0435 (kz)')),  # noqa
                ('enabled_in_wizard_tr', models.BooleanField(default=True, verbose_name='\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0432 \u043a\u043e\u043b\u0434\u0443\u043d\u0449\u0438\u043a\u0435 (tr)')),  # noqa
                ('logo_svg_ru', models.TextField(default=None, max_length=100, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (ru)', blank=True)),
                ('logo_svg_ua', models.TextField(default=None, max_length=100, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (ua)', blank=True)),
                ('logo_svg_kz', models.TextField(default=None, max_length=100, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (kz)', blank=True)),
                ('logo_svg_tr', models.TextField(default=None, max_length=100, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (tr)', blank=True)),
                ('logo_svg_com', models.TextField(default=None, max_length=100, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (com)', blank=True)),
                ('logo_svg2png_ru', models.TextField(default=None, max_length=100, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (ru)', blank=True)),
                ('logo_svg2png_ua', models.TextField(default=None, max_length=100, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (ua)', blank=True)),
                ('logo_svg2png_kz', models.TextField(default=None, max_length=100, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (kz)', blank=True)),
                ('logo_svg2png_tr', models.TextField(default=None, max_length=100, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (tr)', blank=True)),
                ('logo_svg2png_com', models.TextField(default=None, max_length=100, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (com)', blank=True)),
                ('logo2_svg_ru', models.TextField(default=b'', max_length=100, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (ru) \u0432 \u0410\u0432\u0430\u0442\u0430\u0440\u043d\u0438\u0446\u0435', blank=True)),  # noqa
                ('logo2_svg_ua', models.TextField(default=b'', max_length=100, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (ua) \u0432 \u0410\u0432\u0430\u0442\u0430\u0440\u043d\u0438\u0446\u0435', blank=True)),  # noqa
                ('logo2_svg_kz', models.TextField(default=b'', max_length=100, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (kz) \u0432 \u0410\u0432\u0430\u0442\u0430\u0440\u043d\u0438\u0446\u0435', blank=True)),  # noqa
                ('logo2_svg_tr', models.TextField(default=b'', max_length=100, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (tr) \u0432 \u0410\u0432\u0430\u0442\u0430\u0440\u043d\u0438\u0446\u0435', blank=True)),  # noqa
                ('logo2_svg_com', models.TextField(default=b'', max_length=100, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (com) \u0432 \u0410\u0432\u0430\u0442\u0430\u0440\u043d\u0438\u0446\u0435', blank=True)),  # noqa
                ('logo2_svg2png_ru', models.TextField(default=None, max_length=100, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (ru) \u0432 \u0410\u0432\u0430\u0442\u0430\u0440\u043d\u0438\u0446\u0435', blank=True)),  # noqa
                ('logo2_svg2png_ua', models.TextField(default=None, max_length=100, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (ua) \u0432 \u0410\u0432\u0430\u0442\u0430\u0440\u043d\u0438\u0446\u0435', blank=True)),  # noqa
                ('logo2_svg2png_kz', models.TextField(default=None, max_length=100, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (kz) \u0432 \u0410\u0432\u0430\u0442\u0430\u0440\u043d\u0438\u0446\u0435', blank=True)),  # noqa
                ('logo2_svg2png_tr', models.TextField(default=None, max_length=100, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (tr) \u0432 \u0410\u0432\u0430\u0442\u0430\u0440\u043d\u0438\u0446\u0435', blank=True)),  # noqa
                ('logo2_svg2png_com', models.TextField(default=None, max_length=100, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (com) \u0432 \u0410\u0432\u0430\u0442\u0430\u0440\u043d\u0438\u0446\u0435', blank=True)),  # noqa
                ('foreign_currency', models.BooleanField(default=False, help_text='\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0432 \u0432\u0430\u043b\u044e\u0442\u0430\u0445, \u043e\u0442\u043b\u0438\u0447\u043d\u044b\u0445 \u043e\u0442 \u0432\u0430\u043b\u044e\u0442\u044b \u043d\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438', verbose_name='\u0418\u043d\u043e\u0441\u0442\u0440\u0430\u043d\u043d\u044b\u0435 \u0432\u0430\u043b\u044e\u0442\u044b')),  # noqa
                ('national_com_title_ru', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 com \u0432\u0435\u0440\u0441\u0438\u0438 (ru)', blank=True)),  # noqa
                ('national_com_title_en', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 com \u0432\u0435\u0440\u0441\u0438\u0438 (en)', blank=True)),  # noqa
                ('national_com_title_tr', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 com \u0432\u0435\u0440\u0441\u0438\u0438 (tr)', blank=True)),  # noqa
                ('national_com_title_uk', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 com \u0432\u0435\u0440\u0441\u0438\u0438 (uk)', blank=True)),  # noqa
                ('national_ua_title_ru', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (ru)', blank=True)),  # noqa
                ('national_ua_title_en', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (en)', blank=True)),  # noqa
                ('national_ua_title_tr', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (tr)', blank=True)),  # noqa
                ('national_ua_title_uk', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (uk)', blank=True)),  # noqa
                ('title', TrimmedCharField(default='', max_length=100, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430')),  # noqa
                ('title_ru', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 (ru)', blank=True)),  # noqa
                ('title_en', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 (en)', blank=True)),  # noqa
                ('title_tr', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 (tr)', blank=True)),  # noqa
                ('title_uk', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 (uk)', blank=True)),  # noqa
                ('national_kz_title_ru', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (ru)', blank=True)),  # noqa
                ('national_kz_title_en', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (en)', blank=True)),  # noqa
                ('national_kz_title_tr', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (tr)', blank=True)),  # noqa
                ('national_kz_title_uk', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (uk)', blank=True)),  # noqa
                ('national_ru_title_ru', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (ru)', blank=True)),  # noqa
                ('national_ru_title_en', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (en)', blank=True)),  # noqa
                ('national_ru_title_tr', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (tr)', blank=True)),  # noqa
                ('national_ru_title_uk', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (uk)', blank=True)),  # noqa
                ('national_tr_title_ru', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (ru)', blank=True)),  # noqa
                ('national_tr_title_en', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (en)', blank=True)),  # noqa
                ('national_tr_title_tr', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (tr)', blank=True)),  # noqa
                ('national_tr_title_uk', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (uk)', blank=True)),  # noqa
                ('variant_cache_ttl', models.PositiveSmallIntegerField(default=20, verbose_name='\u0412\u0440\u0435\u043c\u044f \u0436\u0438\u0437\u043d\u0438 \u043a\u0435\u0448\u0430 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0439, \u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445', validators=[django.core.validators.MinValueValidator(3), django.core.validators.MaxValueValidator(180)])),  # noqa
                ('description_ru_ru', models.TextField(null=True, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438', blank=True)),  # noqa
                ('description_ua_uk', models.TextField(null=True, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (uk)', blank=True)),  # noqa
                ('description_ua_ru', models.TextField(null=True, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (ru)', blank=True)),  # noqa
                ('description_tr_tr', models.TextField(null=True, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (tr)', blank=True)),  # noqa
                ('description_tr_en', models.TextField(null=True, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (en)', blank=True)),  # noqa
                ('description_kz_ru', models.TextField(null=True, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (ru)', blank=True)),  # noqa
                ('merchant_id', TrimmedCharField(max_length=2, verbose_name='ID \u043c\u0435\u0440\u0447\u0430\u043d\u0442\u0430', db_index=True)),
                ('enabled', models.BooleanField(default=False, verbose_name='\u041c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0448\u0435\u043d \u0447\u0435\u0440\u0435\u0437 \u0434\u0435\u043c\u043e\u043d\u0430')),  # noqa
                ('language_ru', models.CharField(default=b'', max_length=35, verbose_name='\u042f\u0437\u044b\u043a \u0441\u0430\u0439\u0442\u0430 \u0432 \u0432\u0435\u0440\u0441\u0438\u0438 ru', blank=True, choices=[(b'ru-RU', b'ru-RU'), (b'en-EN', b'en-EN'), (b'tr-TR', b'tr-TR')])),  # noqa
                ('language_com', models.CharField(default=b'', max_length=35, verbose_name='\u042f\u0437\u044b\u043a \u0441\u0430\u0439\u0442\u0430 \u0432 \u0432\u0435\u0440\u0441\u0438\u0438 com', blank=True, choices=[(b'ru-RU', b'ru-RU'), (b'en-EN', b'en-EN'), (b'tr-TR', b'tr-TR')])),  # noqa
                ('language_kz', models.CharField(default=b'', max_length=35, verbose_name='\u042f\u0437\u044b\u043a \u0441\u0430\u0439\u0442\u0430 \u0432 \u0432\u0435\u0440\u0441\u0438\u0438 kz', blank=True, choices=[(b'ru-RU', b'ru-RU'), (b'en-EN', b'en-EN'), (b'tr-TR', b'tr-TR')])),  # noqa
                ('language_ua', models.CharField(default=b'', max_length=35, verbose_name='\u042f\u0437\u044b\u043a \u0441\u0430\u0439\u0442\u0430 \u0432 \u0432\u0435\u0440\u0441\u0438\u0438 ua', blank=True, choices=[(b'ru-RU', b'ru-RU'), (b'en-EN', b'en-EN'), (b'tr-TR', b'tr-TR')])),  # noqa
                ('language_tr', models.CharField(default=b'', max_length=35, verbose_name='\u042f\u0437\u044b\u043a \u0441\u0430\u0439\u0442\u0430 \u0432 \u0432\u0435\u0440\u0441\u0438\u0438 tr', blank=True, choices=[(b'ru-RU', b'ru-RU'), (b'en-EN', b'en-EN'), (b'tr-TR', b'tr-TR')])),  # noqa
                ('history_id', models.AutoField(serialize=False, primary_key=True)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(max_length=1, choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')])),
                ('currency_com', models.ForeignKey(related_name='+', on_delete=django.db.models.deletion.DO_NOTHING, db_constraint=False, blank=True, to='avia_data.Currency', null=True)),
                ('currency_kz', models.ForeignKey(related_name='+', on_delete=django.db.models.deletion.DO_NOTHING, db_constraint=False, blank=True, to='avia_data.Currency', null=True)),
                ('currency_ru', models.ForeignKey(related_name='+', on_delete=django.db.models.deletion.DO_NOTHING, db_constraint=False, blank=True, to='avia_data.Currency', null=True)),
                ('currency_tr', models.ForeignKey(related_name='+', on_delete=django.db.models.deletion.DO_NOTHING, db_constraint=False, blank=True, to='avia_data.Currency', null=True)),
                ('currency_ua', models.ForeignKey(related_name='+', on_delete=django.db.models.deletion.DO_NOTHING, db_constraint=False, blank=True, to='avia_data.Currency', null=True)),
                ('history_user', models.ForeignKey(related_name='+', on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL, null=True)),
                ('t_type', models.ForeignKey(related_name='+', on_delete=django.db.models.deletion.DO_NOTHING, db_constraint=False, blank=True, to='www.TransportType', null=True)),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical \u041c\u0435\u0440\u0447\u0430\u043d\u0442 Amadeus',
            },
        ),
    ]
