# -*- coding: utf-8 -*-
from django.conf import settings
from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.avia.library.python.common.models.partner import Partner


class BalanceRedirect(models.Model):
    # TODO: эта модель больше нигде и никем не используется и может быть похоронена
    # https://paste.yandex-team.ru/409870
    billing_order_id = models.PositiveIntegerField(blank=False, null=False)
    partner = models.ForeignKey(
        Partner,
        verbose_name=_(u'Партнер'),
        related_name='+',
        blank=True, null=True
    )
    eventdate = models.DateField(blank=False, null=False)
    eventtime = models.TimeField(blank=False, null=False)
    filtered = models.BooleanField(db_index=True, blank=False, null=False)
    filter_name = models.CharField(max_length=32, blank=True, null=True)
    host = models.CharField(max_length=32, blank=False, null=False)
    national_version = models.CharField(
        _(u'Нац. версия'),
        choices=settings.AVIA_NATIONAL_VERSIONS_CHOICES, default='ru',
        blank=False, null=False,
        max_length=settings.AVIA_NATIONAL_VERSIONS_CHOICES_MAX_LEN
    )
    pp = models.PositiveIntegerField(db_index=True, blank=False, null=False)
    show_id = models.CharField(max_length=32, blank=False, null=False)
    yandexuid = models.CharField(max_length=32, blank=True, null=True)

    class Meta:
        verbose_name = _(u'Клик после антифрода')
        verbose_name_plural = _(u'Клики после антифрода')
        index_together = [
            ['eventdate', 'billing_order_id', 'national_version', 'pp'],
            ['eventdate', 'national_version', 'pp'],
            ['eventdate', 'pp', 'billing_order_id'],
        ]
        app_label = 'avia_data'
        db_table = 'avia_balanceredirect'


class BalanceRedirectPrepeared(models.Model):
    eventdate = models.DateField(blank=False, null=False)
    billing_order_id = models.PositiveIntegerField(blank=False, null=False)
    national_version = models.CharField(
        _(u'Нац. версия'),
        choices=settings.AVIA_NATIONAL_VERSIONS_CHOICES, default='ru',
        blank=False, null=False,
        max_length=settings.AVIA_NATIONAL_VERSIONS_CHOICES_MAX_LEN
    )
    pp = models.PositiveIntegerField(blank=False, null=False)

    count = models.IntegerField(blank=False, null=False)

    class Meta:
        verbose_name = _(u'Агрегированный клик после антифрода')
        verbose_name_plural = _(u'Агрегированные клики после антифрода')
        index_together = [
            ['eventdate', 'billing_order_id', 'national_version', 'pp'],
            ['eventdate', 'national_version', 'pp'],
            ['eventdate', 'pp', 'billing_order_id'],
        ]
        app_label = 'avia_data'
        db_table = 'avia_balanceredirectprepeared'


class BalancePriceListRedirectPrepared(models.Model):
    event_date = models.DateField(blank=False, null=False)
    billing_client_id = models.PositiveIntegerField(blank=False, null=False)
    national_version = models.CharField(
        _(u'Нац. версия'),
        choices=settings.AVIA_NATIONAL_VERSIONS_CHOICES, default='ru',
        blank=False, null=False,
        max_length=settings.AVIA_NATIONAL_VERSIONS_CHOICES_MAX_LEN
    )
    pp = models.PositiveIntegerField(blank=False, null=False)
    count = models.IntegerField(blank=False, null=False)
    cost = models.DecimalField(
        _(u'Расход'),
        max_digits=14, decimal_places=2,
        default=0.0,
        max_length=settings.AVIA_NATIONAL_VERSIONS_CHOICES_MAX_LEN
    )
    payments_count = models.IntegerField(default=0, blank=False, null=False)

    class Meta:
        verbose_name = _(u'Агрегированный клик с ценой клика после антифрода')
        verbose_name_plural = _(u'Агрегированные клики с ценой клика после антифрода')
        index_together = [
            ['event_date', 'billing_client_id', 'national_version', 'pp'],
            ['event_date', 'national_version', 'pp'],
            ['event_date', 'pp', 'billing_client_id'],
        ]
        app_label = 'avia_data'
        db_table = 'avia_balancepricelistredirectprepared'


class ShowLog(models.Model):
    eventdate = models.DateField(blank=False, null=False)
    partner = models.ForeignKey(
        Partner,
        verbose_name=_(u'Партнер'),
        related_name='+',
        blank=False, null=False
    )
    billing_order_id = models.PositiveIntegerField(blank=False, null=False)
    national_version = models.CharField(
        _(u'Нац. версия'),
        choices=settings.AVIA_NATIONAL_VERSIONS_CHOICES, default='ru',
        blank=False, null=False,
        max_length=settings.AVIA_NATIONAL_VERSIONS_CHOICES_MAX_LEN
    )
    pp = models.PositiveIntegerField(blank=False, null=False)
    show_count = models.PositiveIntegerField(blank=False, null=False)

    class Meta:
        verbose_name = _(u'Показ')
        verbose_name_plural = _(u'Показы')
        index_together = [
            ['eventdate', 'billing_order_id', 'national_version', 'pp'],
            ['eventdate', 'national_version', 'pp'],
            ['eventdate', 'pp', 'billing_order_id'],
        ]
        app_label = 'avia_data'
        db_table = 'avia_showlog'
