# -*- coding: utf-8 -*-
from django.db import models
from django.contrib import admin
from django.utils.translation import ugettext_lazy as _


class ServiceLimits(models.Model):
    service = models.CharField(
        verbose_name=_(u'Сервис'),
        max_length=20, null=False, blank=False)

    limited = models.BooleanField(
        verbose_name=_(u'Ограничение числа запросов'),
        default=False, null=False, blank=False)

    def __unicode__(self):
        return u'{}'.format(
            self.service
        )

    class Meta:
        ordering = ('service',)
        verbose_name = _(u'Лимит на ручку API демона')
        verbose_name_plural = _(u'Лимиты ручек API демона')
        app_label = 'avia_data'
        db_table = 'td_api_services_limits'


class ApiHandler(models.Model):
    handler = models.CharField(
        verbose_name=_(u'Ручка демона'),
        max_length=128
    )
    description = models.CharField(
        verbose_name=_(u'Описание ручки демона'),
        max_length=256, null=True, blank=True
    )

    def __unicode__(self):
        return u'{}'.format(
            self.handler
        )

    class Meta:
        verbose_name = _(u'Ручка API демона')
        verbose_name_plural = _(u'Ручки API демона')
        app_label = 'avia_data'
        db_table = 'td_api_handlers'


class Limit(models.Model):
    api_handler = models.ForeignKey(ApiHandler)
    service = models.ForeignKey(ServiceLimits)

    limit = models.IntegerField(
        verbose_name=_(u'Максимальное число запросов'),
    )
    update_time = models.TimeField(
        verbose_name=_(u'Время обнуления лимита'),
        default='00:00:00',
    )
    update_period = models.TimeField(
        verbose_name=_(u'Период обнуления лимита'), null=True, blank=True,
    )

    class Meta:
        verbose_name = _(u'Лимит на ручку API демона')
        verbose_name_plural = _(u'Лимиты ручек API демона')
        app_label = 'avia_data'
        db_table = 'td_api_limits'


class LimitAdminInline(admin.TabularInline):
    model = Limit
    extra = 0


class ServiceLimitsAdmin(admin.ModelAdmin):
    inlines = (LimitAdminInline,)


admin.site.register(ServiceLimits, ServiceLimitsAdmin)


class ApiHandlerAdmin(admin.ModelAdmin):
    pass

admin.site.register(ApiHandler, ApiHandlerAdmin)
