# -*- coding: utf-8 -*-
from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.avia.library.python.common.utils.fields import TrimmedCharField


class NationalVersion(models.Model):
    code = TrimmedCharField(
        verbose_name=_(u'Код национальной версии'), max_length=3, unique=True)

    name = models.CharField(verbose_name=_(u'Название'), max_length=50)

    def __unicode__(self):
        return u'[{}] {}'.format(self.code, self.name)

    def save(self, *args, **kwargs):
        if self.code:
            self.code = self.code.lower()
        return super(NationalVersion, self).save(*args, **kwargs)

    class Meta:
        verbose_name = _(u'Национальная версия')
        verbose_name_plural = _(u'Национальные версии')
        app_label = 'avia_data'
        db_table = 'avia_nationalversion'
