# coding=utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.avia.library.python.avia_data.models import NationalVersion
from travel.avia.library.python.common.models.partner import Partner


class PopularPartners(models.Model):
    """
    Модель хранит популярность партнеров по нац. версиям
    !!! Если популярность партнера в нац. версии мала, то записи не будет
    """

    national_version = models.ForeignKey(NationalVersion)
    partner = models.ForeignKey(Partner)
    score = models.FloatField(verbose_name=_(u'популярность партнера'))

    def __repr__(self):
        return u'(nv: [{}], partner: [{}], score: [{}])'.format(
            self.national_version.code,
            self.partner.code,
            self.score
        )

    class Meta:
        verbose_name = _(u'Популярность партнера')
        verbose_name_plural = _(u'Популярности партнера')
        app_label = 'avia_data'
        db_table = 'avia_partnerpopularity'


class PopularPartnersByRoute(models.Model):
    """
    Модель хранит популярность партнеров по направлениям
    !!! Если популярность партнера по направлению мала, то записи не будет
    """
    STATION_TYPE = 0
    SETTLEMENT_TYPE = 1
    TYPE_TO_NAME = {
        STATION_TYPE: 'Station',
        SETTLEMENT_TYPE: 'Settlement'
    }
    POINT_TYPES = (
        (STATION_TYPE, TYPE_TO_NAME[STATION_TYPE]),
        (SETTLEMENT_TYPE, TYPE_TO_NAME[STATION_TYPE])
    )
    POINT_PREFIX_MAP = {
        'c': SETTLEMENT_TYPE,
        's': STATION_TYPE,
    }

    from_id = models.IntegerField(verbose_name=_(u'ID точки отправления'))
    from_type = models.IntegerField(
        choices=POINT_TYPES,
        verbose_name=_(u'тип точки отправления')
    )
    to_id = models.IntegerField(verbose_name=_(u'ID точки прибытия'))
    to_type = models.IntegerField(
        choices=POINT_TYPES,
        verbose_name=_(u'тип точки прибытия')
    )

    national_version = models.ForeignKey(NationalVersion)

    partner = models.ForeignKey(Partner)
    score = models.FloatField(verbose_name=_(u'популярность партнера'))

    def __repr__(self):
        return (
            u'(nv: [{}], route: [{}:{}-{}:{}], '
            u'partner: [{}], score: [{}])'.format(
                self.national_version.code,
                self.TYPE_TO_NAME[self.from_type], self.from_id,
                self.TYPE_TO_NAME[self.to_type], self.to_id,
                self.partner.code,
                self.score
            )
        )

    class Meta:
        verbose_name = _(u'Популярность партнера по направлениям')
        verbose_name_plural = _(u'Популярности партнера по направлениям')
        app_label = 'avia_data'
        db_table = 'avia_partnerpopularitybyroute'
