# -*- coding: utf-8 -*-
from django.db import models
from django.utils.translation import ugettext_lazy as _


class RazladkiLastProcessedTable(models.Model):
    STREAM = 0
    WHOLE_TABLE = 1
    TABLE_WITH_OFFSET = 2
    TYPES = {
        STREAM: 'stream',
        WHOLE_TABLE: 'whole_table',
        TABLE_WITH_OFFSET: 'table_with_offset',
    }

    log_name = models.CharField(
        max_length=50, verbose_name=_(u'Лог'),
        unique=True,
        blank=False,
        null=False,
    )

    timestamp = models.DateTimeField(
        verbose_name=_(u'Последняя обработанная таблица'),
    )

    yt_path = models.TextField(
        verbose_name=_(u'Корневая директория YT'),
        null=False,
        blank=False,
    )

    mode = models.PositiveSmallIntegerField(
        verbose_name=_(u'Тип поставки'),
        choices=TYPES.items(),
        default=WHOLE_TABLE,
    )

    offset = models.IntegerField(
        verbose_name=_(u'Смещение в таблице'),
        null=True,
        blank=True,
        default=None,
    )

    class Meta:
        verbose_name = _(u'Поставка данных в разладки')
        app_label = 'avia_data'
        db_table = 'settings_razladki'
