# -*- coding: utf-8 -*-
from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.avia.library.python.common.utils.fields import TrimmedCharField


class Registry(models.Model):
    key = TrimmedCharField(verbose_name=_(u'Ключ'), max_length=250, null=False, blank=False, db_index=True)
    val = TrimmedCharField(verbose_name=_(u'Значение'), max_length=250, null=False, blank=False)

    def __unicode__(self):
        return u'{!r} {!r}'.format(self.key, self.val)

    class Meta:
        verbose_name = _(u'Запись в реестре')
        verbose_name_plural = _(u'Записи в реестре')
        app_label = 'avia_data'
        db_table = 'avia_registry'
