# -*- coding: utf-8 -*-
from django.db import models
from django.utils.translation import ugettext_lazy as _


class RelevantCityAirline(models.Model):
    """топ АК, которые летают в город для лэндинга "авиабилеты в город"."""
    airline = models.ForeignKey('www.Company', related_name='+')
    national_version = models.ForeignKey('avia_data.NationalVersion', related_name='+')
    settlement_to = models.ForeignKey('www.Settlement', verbose_name=_(u'Город куда'), related_name='+')
    score = models.IntegerField(_(u'Количество рейсов АК в этот город'))

    class Meta:
        verbose_name = _(u'АК для авиабилетов в город')
        verbose_name_plural = _(u'АК для авиабилетов в город')
        app_label = 'avia_data'
        db_table = 'avia_relevant_city_airline'
