# -*- coding: utf-8 -*-

from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.avia.library.python.common.models.geo import Settlement


class TourDeparture(models.Model):
    geo_id = models.IntegerField(verbose_name=_(u'Geo ID'))
    settlement = models.ForeignKey(
        Settlement,
        verbose_name=_(u'Город'),
        related_name='+'
    )

    class Meta:
        verbose_name = _(u'город отправления туров')
        verbose_name_plural = _(u'города отправления туров')
        app_label = 'avia_data'
        db_table = 'avia_tourdeparture'


class TourDestination(models.Model):
    geo_id = models.IntegerField(verbose_name=_(u'Geo ID'))
    settlement = models.ForeignKey(
        Settlement,
        verbose_name=_(u'Город'),
        related_name='+'
    )

    class Meta:
        verbose_name = _(u'город назначения туров')
        verbose_name_plural = _(u'города назначения туров')
        app_label = 'avia_data'
        db_table = 'avia_tourdestination'


class ToursMatrix(models.Model):
    from_geo_id = models.IntegerField(verbose_name=_(u'From Geo ID'))
    to_geo_id = models.IntegerField(verbose_name=_(u'To Geo ID'))

    class Meta:
        verbose_name = _(u'перелёт туров')
        verbose_name_plural = _(u'перелёты туров')
        app_label = 'avia_data'
        db_table = 'avia_toursmatrix'
        unique_together = ('from_geo_id', 'to_geo_id')
