# -*- coding: utf-8 -*-
from .models.registry import Registry

RASP_CURRENT_DEFAULT_DB_NAME_KEY = 'rasp_current_default_db_name'


class RegistryError(Exception):
    pass


def reg_set(key, val):
    record, created = Registry.objects.get_or_create(key=key)
    if created or record.val != val:
        record.val = val
        record.save()


def reg_set_check(key, val):
    reg_set(key, val)
    if reg_get(key) != val:
        raise RegistryError('Not set: %r' % key)


def reg_get(key, default=None):
    try:
        return Registry.objects.filter(key=key).values_list('val', flat=True)[0]
    except IndexError:
        return default
