# -*- coding: utf-8 -*-

FOTKI_TOKEN = '2e01a50b7a254420b0f2ebc76f5761bb'
FOTKI_USER = 'yndx-service-avia'
FOTKI_SETTLEMENT_ALBUM = '454155'
FOTKI_SETTLEMENT_ALBUM_BIG = '456056'
FOTKI_SETTLEMENT_ALBUM_SMALL = '456057'

AVIA_PARTNER_FETCH_SUBJECT = None
AVIA_PARTNER_FETCH_MAIL = None

TOURS_HOST = 'tours-api.http.yandex.net'
TOURS_PORT = 36400

AVIA_NATIONAL_VERSIONS = ['ru', 'ua', 'tr', 'com', 'kz']
AVIA_NATIONAL_VERSIONS_CHOICES = tuple([(v, v) for v in AVIA_NATIONAL_VERSIONS])
AVIA_NATIONAL_VERSIONS_CHOICES_MAX_LEN = 5  # Изменять только вместе с миграцией!

if max(len(v) for v in AVIA_NATIONAL_VERSIONS) > AVIA_NATIONAL_VERSIONS_CHOICES_MAX_LEN:
    message = 'Len of one of national version is bigger AVIA_NATIONAL_VERSIONS_CHOICES_MAX_LEN={max_len}'.format(
        max_len=AVIA_NATIONAL_VERSIONS_CHOICES_MAX_LEN
    )
    raise ValueError(message)

AVIA_NATIONAL_CURRENCIES = {
    'ru': 'RUR',
    'ua': 'UAH',
    'kz': 'KZT',
    'tr': 'TRY',
    'com': 'EUR',
}

AVIA_NATIONAL_VERSION_ALLOWED_FOREIGN_CURRENCIES = {
    'ru': ('USD', 'EUR', 'GBP'),
    'ua': ('BYR', 'BYN', 'CHF', 'EUR', 'GBP', 'JPY', 'KZT', 'NOK', 'RUB', 'RUR', 'TRY', 'UAH', 'USD'),
    'kz': ('EUR', 'USD', 'RUB', 'RUR'),
    'tr': ('JPY', 'USD', 'CHF', 'CNY', 'TRY', 'UAH', 'GBP', 'RUB', 'RUR', 'EUR'),
    'com': tuple(
        """ AUD BGN BRL CAD CHF CNY CZK DKK GBP HKD HRK HUF IDR ILS INR JPY KRW
        MXN MYR NOK NZD PHP PLN RON RUB RUR SEK SGD THB TRY USD ZAR
        """.strip().split()
    ),
}

SITEMAP_NATIONAL_MAP = {'ru': 'ru', 'ua': 'ua', 'com.tr': 'tr', 'com': 'com', 'kz': 'kz'}
SITEMAP_NATIONAL_LANGS = {
    'ru': ['ru', 'en'],
    'ua': ['uk', 'ru', 'en'],
    'kz': ['ru', 'en'],
    'tr': ['tr', 'en'],
    'com': ['en'],
}
SITEMAP_NATIONAL_VERSION_DEFAULT_LANG = {'ru': 'ru', 'ua': 'uk', 'tr': 'tr', 'com': 'en', 'kz': 'ru'}

CURRENCY_RATES_TIMEOUT = 0.1

MOSCOW_GEO_ID = 213
RUSSIA_GEO_ID = 225

KIEV_GEO_ID = 143
UKRAINE_GEO_ID = 187

ASTANA_GEO_ID = 163
IKAZAKHSTAN_GEO_ID = 159

ISTANBUL_GEO_ID = 11508
TURKEY_GEO_ID = 983

BRUSSEL_GEO_ID = 10376
BELGIUM_GEO_ID = 114

NATIONAL_CURRENCY_RATES_GEOID = {
    'ru': MOSCOW_GEO_ID,
    'ua': KIEV_GEO_ID,
    'kz': ASTANA_GEO_ID,
    'tr': ISTANBUL_GEO_ID,
    'com': BRUSSEL_GEO_ID,
}
