# -*- coding: UTF-8 -*-

import requests
import logging
from lxml import etree

from django.core.files.storage import Storage
from django.utils.deconstruct import deconstructible

from travel.avia.library.python.avatars.storage import (  # noqa
    AVATAR_WRITE_URL, AVATAR_READ_URL, AvatarsStorage, AvatarsPngStorage, AvatarsSvgStorage
)

log = logging.getLogger(__name__)


@deconstructible
class YFStorage(Storage):
    fotki_url = 'https://api-fotki.yandex.ru'

    def __init__(self, token, user, album):
        self.token = token
        self.user = user
        self.album = album

    def _request_url(self):
        return '%s/api/users/%s/album/%s/photos/' % (
            self.fotki_url, self.user, self.album
        )

    def _open(self, name, mode='rb'):
        pass

    def _save(self, name, content):
        url = self._request_url()

        headers = {
            'Authorization': 'OAuth %s' % self.token
        }

        data = {
            'disable_comments': 'true',
            'access_type': 'public',
            # В документации false значение по-умолчанию, но для некоторых альбомов оно true o_O
            'hide_original': 'false',
        }

        # Это админка, так что если что-то не так, то пусть падает с оригинальной ошибкой
        r = requests.post(url, headers=headers, data=data, files={
            'image': content.read()
        })

        tree = etree.fromstring(r.content)

        # Именно там лежит оригинальный урл, посмотрел другие реализации - все хардкодят 3
        return tree.findall('{http://www.w3.org/2005/Atom}link')[3].get('href')

    def delete(self, name):
        pass

    def exists(self, name):
        return False

    def listdir(self, path):
        pass

    def size(self, name):
        return None

    def url(self, path):
        return path
