# -*- coding: utf-8 -*-

from operator import itemgetter
from PIL import Image

""" Image Gradients
Module for analysing images for their 4 most
prominant colors, and creating a CSS gradient.

Идея взята отсюда: https://github.com/fraser-hemp/gradify
модулем подключать не ок, оно делает лишнее и код там очень кривой
вытащил оттуда алгоритм для получения того что нам нужно
"""


def make_css(colors):
    gradients = []
    pattern = 'linear-gradient({}deg, rgba({},{},{},1) 0%, rgba({},{},{},0) 100%)'

    for color in colors:
        args = [
            str(i) for i in (
                color[3],
                color[0], color[1], color[2],
                color[0], color[1], color[2]
            )
        ]
        gradients.append(pattern.format(*args))

    return ','.join(gradients) + ';'


class Gradify(object):
    def __init__(self):
        # кол-во цветов которые вытаскиваем
        self.MAX_COLORS = 4

        # Цвета считаем по миниатюре, а не полной картинки
        self.RESIZE_VAL = 55

        # чувствительность
        self.UNIFORMNESS = 7

        self.IGNORED_COLORS = {
            'BLACK': {
                'col': (0, 0, 0),
                'radius': 4.3
            },
            'WHITE': {
                'col': (255, 255, 255),
                'radius': 3
            }
        }

    def get_directions(self):
        # я не понял зачем ресайзить до 100, но пусть будет
        resized = self.image.resize((100, 100), Image.ANTIALIAS)
        self.image = resized
        colors = self.get_colors()

        cols_quads = [0] * 4

        for i, color in enumerate(colors):
            count = 0
            # 0 - left, 1 - bottom, 2 - right, 3 - top
            a = [0] * 4
            for pix in resized.getdata():
                if self.get_RGB_diff(pix, colors[i]) < 4.2:
                    if int((count % 100) / 50) == 1:
                        a[2] += 1
                    else:
                        a[0] += 1
                    if int((count / 100.0) / 50) == 0:
                        a[3] += 1
                    else:
                        a[1] += 1
                count += 1

            cols_quads[i] = a

        quad_cols = self.calculate_spread(cols_quads, colors)
        return quad_cols

    def get_colors(self):
        self.colors = []

        self.image = self.image.resize((self.RESIZE_VAL, self.RESIZE_VAL), Image.ANTIALIAS)

        ranked_colors = sorted(
            self.image.getcolors(self.image.size[0] * self.image.size[1]),
            key=itemgetter(0), reverse=True
        )
        self.colors = ranked_colors

        if self.MAX_COLORS == 1:
            return self.colors[0]
        else:
            return self.find_best_colors()

    def find_best_colors(self):
        selectedColors = []
        bad_color = False
        sensitivity = self.UNIFORMNESS
        ignored_radius = 0

        while (len(selectedColors) < self.MAX_COLORS):
            selectedColors = []

            for color in self.colors:
                bad_color = False
                for col, col_dict in self.IGNORED_COLORS.iteritems():
                    diff = self.get_RGB_diff(col_dict['col'], color[1])
                    if diff < col_dict['radius'] - ignored_radius:
                        # IF too close to Black or White, ignore this color
                        bad_color = True
                        break

                for j in range(len(selectedColors)):
                    diff = self.get_RGB_diff(color[1], selectedColors[j])
                    if (diff < sensitivity):
                        # IF too close to any other selected color, ignore.
                        bad_color = True
                        break

                if bad_color:
                    continue

                selectedColors.append(color[1])

            if ignored_radius < 2:
                ignored_radius += 1
            else:
                sensitivity -= 1
                ignored_radius = 0

        return selectedColors[0:4]

    def get_RGB_diff(self, old, new):
        # Currently an approximation of LAB colorspace
        return abs(
            1.4 * abs(old[0] - new[0]) ** (1 / 2.0) +
            .8 * abs(old[1] - new[1]) ** (1 / 2.0) +
            .8 * abs(old[2] - new[2]) ** (1 / 2.0)
        ) ** (1 / 2.0)

    def calculate_spread(self, spread_quads, colors):
        strength_spread = []
        quad_cols = [0] * 4
        taken_col = [0] * 4
        taken_quads = [0] * 4

        for quad in spread_quads:
            top = quad[3] * 1.0 / (quad[1] + 0.01)
            left = quad[2] * 1.0 / (quad[0] + 0.01)
            if left < 1:
                left = 1 / (left + 0.01)
            if top < 1:
                top = 1 / (top + 0.01)

            strength_spread.append(top)
            strength_spread.append(left)

        while 0 in taken_col:
            if max(strength_spread) == 0:
                best_col = taken_col.index(0)
            else:
                best_col = int(strength_spread.index(max(strength_spread)) / 2)

            if taken_col[best_col] == 0:
                best_quad = spread_quads[best_col].index(max(spread_quads[best_col]))

                if max(spread_quads[best_col]) == 0:
                    best_quad = taken_quads.index(0)

                if taken_quads[best_quad] == 0:
                    taken_quads[best_quad] = 1
                    taken_col[best_col] = 1
                    colors[best_col] = list(colors[best_col])
                    colors[best_col].append(best_quad * 90 - 90)
                    quad_cols[best_col] = colors[best_col]

                spread_quads[best_col][best_quad] = 0

            strength_spread[strength_spread.index(max(strength_spread))] = 0

        return quad_cols

    def get_css(self, path):
        self.image = Image.open(path)
        colors = self.get_directions()
        return make_css(colors)
