PY2_LIBRARY(avia_data)

OWNER(g:avia)

PEERDIR(
    contrib/python/Babel
    contrib/python/cachetools
    contrib/python/django-model-utils
    contrib/python/django/django-1.11
    contrib/python/enum34
    contrib/python/lxml
    contrib/python/python-memcached
    contrib/python/pytils
    contrib/python/retrying
    contrib/python/scour

    geobase/python/static

    library/python/blackbox
    library/python/cookiemy
    library/python/django
    library/python/ylog

    sandbox/common/rest

    travel/library/python/dicts
    travel/library/python/avia_mdb_replica_info
    travel/avia/library/python/image_processing
    travel/avia/library/python/avatars
)


PY_SRCS(
    __init__.py
    django_commands/__init__.py
    django_commands/management/__init__.py
    django_commands/management/commands/__init__.py
    django_commands/management/commands/cache_currency_rates.py
    fill_css_gradient_once.py
    libs/__init__.py
    libs/currency/__init__.py
    libs/currency/rates/__init__.py
    libs/currency/rates/caching.py
    libs/currency/rates/converter.py
    libs/currency/rates/dohop_converter.py
    migrations/0001_initial.py
    migrations/0002_create_model_registry.py
    migrations/0003_registry_key_dbindex.py
    migrations/0004_index_on_topflight.py
    migrations/0005_tune_amadeusmerchant.py
    migrations/0006_flightnumber_airline.py
    migrations/0007_auto_20160726_1320.py
    migrations/0008_flightreview_dirty_lang_class.py
    migrations/0009_variant_cache_ttl_for_amadeus_merchant.py
    migrations/0010_new_upper_bound_for_merchant_variant_cache_time.py
    migrations/0011_auto_20160817_1131.py
    migrations/0012_tablo.py
    migrations/0013_del_deprecated.py
    migrations/0014_balanceredirect.py
    migrations/0014_selfbookrule.py
    migrations/0015_showlog.py
    migrations/0016_showlog_billing_order_id.py
    migrations/0017_balanceredirect_showlog_indices.py
    migrations/0018_balanceredirectprepeared.py
    migrations/0019_pp_601_to_502.py
    migrations/0020_adminsettlementbigimage_url2.py
    migrations/0021_auto_20170123_1419.py
    migrations/0022_auto_20170129_1253.py
    migrations/0022_aviarecipe_meta_title_key.py
    migrations/0023_merge.py
    migrations/0024_nationalversion.py
    migrations/0025_fill_nationalversion.py
    migrations/0026_selfbooknationalversion.py
    migrations/0027_goodprices.py
    migrations/0027_merge.py
    migrations/0028_fill_production_avatar_urls.py
    migrations/0029_merge.py
    migrations/0029_minprice_airlines.py
    migrations/0030_merge.py
    migrations/0031_create_td_api_limits.py
    migrations/0032_auto_20170329_1655.py
    migrations/0033_default_update_time.py
    migrations/0034_strip_size_suffix_from_avatar_urls.py
    migrations/0035_add_baggage_pieces_field.py
    migrations/0036_company_rating.py
    migrations/0036_create_tablo_source.py
    migrations/0036_site_url_for_amadeus_merchant.py
    migrations/0037_fill_empty_tablo_source_for_all_airports.py
    migrations/0038_merge.py
    migrations/0039_aviacompany_baggage_price.py
    migrations/0040_auto_20170913_1758.py
    migrations/0041_auto_20170918_0356.py
    migrations/0042_auto_20171017_1254.py
    migrations/0042_create_similar_airlines.py
    migrations/0043_avia_recipe_backward_dates.py
    migrations/0044_wizard_settings.py
    migrations/0045_delete_S7CircuitLimits.py
    migrations/0046_auto_20180207_1541.py
    migrations/0047_add_aviacompany_iata.py
    migrations/0048_fill_company_iatas.py
    migrations/0049_aggregated_redirects_for_new_scheme.py
    migrations/0050_relevant_city_airline.py
    migrations/0051_merge.py
    migrations/0052_volgograd_time_zone.py
    migrations/0053_volgograd_time_zone_stations.py
    migrations/0054_auto_20190112_1600.py
    migrations/0055_auto_20190130_1012.py
    migrations/0056_balancepricelistredirectprepared_payments_count.py
    migrations/0057_auto_20190321_1003.py
    migrations/0058_airporttablosource_trusted.py
    migrations/0059_auto_20190705_1651.py
    migrations/0060_auto_20190708_1541.py
    migrations/0061_auto_20190708_1615.py
    migrations/0062_auto_20190709_1514.py
    migrations/0063_add_fields_amadeus.py
    migrations/0064_delete_wizardsetting.py
    migrations/0065_add_nationalversion_query_param.py
    migrations/0066_amadeus_inheritance.py
    migrations/0067_auto_20190903_2108.py
    migrations/0068_pricing_model.py
    migrations/0069_review_percent_by_nationals.py
    migrations/0070_add_procedure_for_changing_foreign_key_constraints.py
    migrations/0071_modify_foreign_key_on_www_company.py
    migrations/0072_create_air_traffic_recovery_stat.py
    migrations/0073_add_airtrafficrecoverystat_next_direct_flight_day_field.py
    migrations/0074_add_airtrafficrecoverystat_coefficients.py
    migrations/0075_auto_20200605_1838.py
    migrations/0076_auto_20200611_1019.py
    migrations/0077_fix-add_on_cascade_to_referers.py
    migrations/0078_add_missing_foreign_key_constraints.py
    migrations/0079_add_historical_amadeus_merchant.py
    migrations/0080_aviacompany__add_field__baggage_rules_are_valid.py
    migrations/0081_auto_add_icon_svg_to_partners.py
    migrations/__init__.py
    migrations_data/__init__.py
    migrations_data/iso_codes__0016.py
    models/__init__.py
    models/air_traffic_recovery.py
    models/amadeus_merchant.py
    models/balance.py
    models/company.py
    models/currency.py
    models/directions.py
    models/images.py
    models/limits.py
    models/national_version.py
    models/popular_partners.py
    models/prices.py
    models/razladki.py
    models/registry.py
    models/review.py
    models/selfbook.py
    models/seo_top.py
    models/tablo.py
    models/tours.py
    registry.py
    settings.py
    storage.py
    utils/__init__.py
    utils/django_utils.py
    utils/gradify.py
)

NO_CHECK_IMPORTS(
    model_utils.*
    pytils.*
    avia_data.*
)

END()

RECURSE(
    tests
)

RECURSE_FOR_TESTS(
    tests/py2
)

