# -*- encoding: utf-8 -*-
from __future__ import absolute_import

try:
    import xmlrpclib
except ImportError:
    import xmlrpc.client as xmlrpclib

from travel.library.python.tvm_ticket_provider import provider_fabric


class TvmTransport(xmlrpclib.SafeTransport):
    def __init__(self, tvm_balance_alias, tvm_client_id, *args, **kwargs):
        # type: (str, int, list, dict) -> None
        self._tvm_balance_alias = tvm_balance_alias
        self._tvm_client_id = tvm_client_id
        self._tvm_provider = None
        xmlrpclib.SafeTransport.__init__(self, *args, **kwargs)

    def send_host(self, connection, request_body):
        xmlrpclib.SafeTransport.send_host(self, connection, request_body)
        connection.putheader('X-Ya-Service-Ticket', self._get_tvm_ticket())

    def _get_tvm_ticket(self):
        if not self._tvm_provider:
            self._tvm_provider = provider_fabric.create(
                source_id=self._tvm_client_id,
                destinations=[self._tvm_balance_alias],
                renew=True,
            )

        return self._tvm_provider.get_ticket(self._tvm_balance_alias)
