from typing import Protocol, Any


class S3ClientProto(Protocol):
    def upload_file(self, local_file: str, bucket: str, path: str) -> None:
        pass

    def list_objects(self, Bucket: str, Prefix: str) -> dict[str, Any]:
        pass

    def get_object(self, Bucket: str, Key: str) -> dict[str, Any]:
        pass

    def delete_object(self, Bucket: str, Key: str) -> None:
        pass

    def put_object(self, Bucket: str, Key: str, Body: bytes) -> None:
        pass
