#!/usr/bin/env python2

"""
Run python scripts within project python environment
"""

import os
import sys


activate_this = os.path.join(os.path.dirname(__file__), '..', 'activate_this.py')

execfile(activate_this, dict(__file__=activate_this))

# As initialized upon program startup, the first item of this list, path[0], is the directory
# containing the script that was used to invoke the Python interpreter. If the script directory is
# not available (e.g. if the interpreter is invoked interactively or if the script is read from
# standard input), path[0] is the empty string, which directs Python to search modules in the
# current directory first.

sys.argv.pop(0)  # this script

if sys.argv:
    script = sys.argv[0]
    sys.path[0] = os.path.dirname(script)
    execfile(script)
else:
    sys.path[0] = ''
    sys.argv.append('')
    import code
    code.interact()
