from datetime import datetime, timedelta  # noqa

from typing import Generator, Tuple, Optional  # noqa

from travel.avia.library.python.common.models.holidays import Holiday  # noqa


def generate_holiday_search_dates(holiday, one_way_trip, window_width=2):
    # type: (Holiday, bool, int) -> Generator[Tuple[datetime, Optional[datetime]]]
    window_width = timedelta(days=window_width)
    one_day = timedelta(days=1)

    date_forward = holiday.first_day - window_width
    while date_forward <= holiday.first_day + window_width:
        if one_way_trip:
            yield (date_forward, None)
        else:
            date_backward = max(date_forward, holiday.last_day - window_width)
            while date_backward <= holiday.last_day + window_width:
                yield (date_forward, date_backward)
                date_backward += one_day

        date_forward += one_day
