# -*- coding: utf-8 -*-

from django.db import models


class Flag(models.Model):
    name = models.CharField(max_length=255, primary_key=True)
    state = models.IntegerField(null=False)
    description = models.CharField(null=False, max_length=255)
    modified_on = models.DateTimeField(auto_now=True, null=False)
    note = models.TextField(null=True)

    class Meta:
        db_table = 'flags'
