# -*- coding: utf-8 -*-
import sys

from importlib import import_module

from django.core.management import ManagementUtility, get_commands, BaseCommand


class AviaManagementUtility(ManagementUtility):
    """
        Менеджер, который для всех команд отменяет затирание базовой локали.
        @see https://github.com/django/django/commit/f7c287fca9c9e6370cc88d1457d3ed9466703687

        Я перетер минимальную функциональность от родительского класса, а все остальное из django 1.8
    """

    def fetch_command(self, subcommand):
        # Get commands outside of try block to prevent swallowing exceptions
        commands = get_commands()
        try:
            app_name = commands[subcommand]
        except KeyError:
            sys.stderr.write("Unknown command: %r\nType '%s help' for usage.\n" %
                             (subcommand, self.prog_name))
            sys.exit(1)
        if isinstance(app_name, BaseCommand):
            # If the command is already loaded, use it directly.
            klass = app_name
        else:
            # !!! изменил эту строчку
            klass = self.load_command_class(app_name, subcommand)
        return klass

    def load_command_class(self, app_name, name):
        module = import_module('%s.management.commands.%s' % (app_name, name))

        command = module.Command()
        # !!! добавил эту строчку !!!
        command.leave_locale_alone = True

        return command


def execute_from_command_line(argv):
    utility = AviaManagementUtility(argv)
    utility.execute()
